% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_im.R
\name{ef_im}
\alias{ef_im}
\title{Emission factors deoending on accumulated mileage}
\usage{
ef_im(ef, tc, amileage, max_amileage, max_ef, verbose = TRUE)
}
\arguments{
\item{ef}{Numeric; emission factors of vehicles with \strong{0 mileage}
(new vehicles).}

\item{tc}{Numeric; rate of growth of emissions by year of use.}

\item{amileage}{Numeric; Accumulated mileage by age of use.}

\item{max_amileage}{Numeric; Max accumulated mileage. This means that after
this value, mileage is constant.}

\item{max_ef}{Numeric; Max ef. This means that after this value, ef is constant.}

\item{verbose}{Logical; if you want detailed description.}
}
\value{
An emission factor of a deteriorated vehicle under normal conditions
which would be approved in a inspection and mantainence program.
}
\description{
\code{\link{ef_im}} calculate the theoretical emission factors of vehicles.
The approache is different from including deterioration factors
(\code{\link{emis_det}})  but similar, because they represent how much emits
a vehicle with a normal deterioration, but that it will pass the
Inspection and Manteinance program.
}
\examples{
\dontrun{
# Do not run
# Passenger Cars PC
data(fkm)
# cumulative mileage from 1 to 50 years of use, 40:50
mil <- cumsum(fkm$KM_PC_E25(1:10))
ef_im(ef = seq(0.1, 2, 0.2), seq(0.1, 1, 0.1), mil)
}
}
\keyword{emission}
\keyword{factors}
\keyword{mileage}
