% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woolf_test.R
\name{woolf_test}
\alias{woolf_test}
\alias{print.woolf_test}
\title{Woolf Test for Homogeneity of Odds Ratios}
\usage{
woolf_test(x, decompose = FALSE)

\method{print}{woolf_test}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"woolf_test"}}

\item{decompose}{Logical. If \code{TRUE} and \code{x} is 4-dimensional
(a \eqn{2 \times 2 \times R \times C}{2 x 2 x R x C} table), the test
is decomposed into row effects, column effects, and residual (interaction).
Defaults to \code{FALSE}. Ignored for non-4-dimensional tables.}

\item{...}{Additional arguments (currently unused)}
}
\value{
A list of class \code{"woolf_test"} (also inheriting from \code{"htest"})
containing the following components:
\item{statistic}{the chi-squared test statistic.}
\item{parameter}{degrees of freedom of the approximate chi-squared
distribution of the test statistic.}
\item{p.value}{\eqn{p}-value for the test.}
\item{method}{a character string indicating the type of test performed.}
\item{data.name}{a character string giving the name of the data.}
\item{or_vars}{names of the first two dimensions (the 2x2 table variables).}
\item{strata_vars}{names of the stratifying variables (dimensions 3 and beyond).}
\item{observed}{the observed log odds ratios.}
\item{expected}{the expected log odds ratio under the null hypothesis (weighted mean).}
\item{decomposed}{logical indicating if decomposition was performed.}

When \code{decompose = TRUE} (only for 4-dimensional tables), additional components:
\item{rows}{list with statistic, df, p.value, observed, expected for row effects.}
\item{cols}{list with statistic, df, p.value, observed, expected for column effects.}
\item{residual}{list with statistic, df, p.value for residual (interaction).}
}
\description{
Test for homogeneity on \eqn{2 \times 2 \times k}{2 x 2 x k} tables
over strata (i.e., whether the log odds ratios are the same in all
strata). Generalized to handle tables of any dimensionality beyond 3.
For 4-dimensional tables, optionally provides a two-way decomposition
of the homogeneity test into row effects, column effects, and residual.
}
\details{
The Woolf test (Woolf, 1955) tests the hypothesis that the odds ratios
\eqn{\theta_i} are equal across all \eqn{k} strata. The test statistic
is computed as the weighted sum of squared deviations of the log odds ratios
from their weighted mean:

\deqn{\chi^2_W = \sum_{i=1}^{k} w_i [\log(\theta_i) - \log(\bar{\theta}_w)]^2
      = \sum_{i=1}^{k} w_i \log^2(\theta_i / \bar{\theta}_w)}

where \eqn{\theta_i = (n_{11i} n_{22i}) / (n_{12i} n_{21i})} is the odds ratio
in stratum \eqn{i}, and \eqn{\bar{\theta}_w} is the weighted average odds ratio
(computed as the exponential of the weighted mean of the log odds ratios).

The weights \eqn{w_i} are the inverse variances of the log odds ratios:
\deqn{w_i = 1 / \text{Var}(\log \theta_i) = 1 / (1/n_{11i} + 1/n_{12i} + 1/n_{21i} + 1/n_{22i})}

Under the null hypothesis of homogeneous odds ratios, \eqn{\chi^2_W} follows
a chi-squared distribution with \eqn{k - 1} degrees of freedom.

\strong{Decomposition for 4-way tables:}
For a \eqn{2 \times 2 \times R \times C} table, the strata
form an \eqn{R \times C} two-way layout with odds ratios
\eqn{\theta_{ij}} for row \eqn{i} and column \eqn{j}. This suggests
that overall Woolf test
of homogeneity can be decomposed into three components, conceptually
analogous to a two-way ANOVA with one observation per cell:

\deqn{\chi^2_{\text{W:Total}} = \chi^2_{\text{W:Rows}} + \chi^2_{\text{W:Cols}} + \chi^2_{\text{W:Residual}}}

where:
\itemize{
\item \eqn{\chi^2_{\text{W:Rows}} } tests whether the odds ratios differ among
row levels (pooling over columns), with \eqn{R - 1} df
\item \eqn{\chi^2_{\text{W:Cols}}} tests whether the odds ratios differ among
column levels (pooling over rows), with \eqn{C - 1} df
\item \eqn{\chi^2_{\text{W:Residual}}} tests the row \eqn{\times}{x} column interaction
(deviation from additivity on the log odds scale), with \eqn{(R-1)(C-1)} df
}

The row effect test compares the marginal log odds ratios
\eqn{\log \bar{\theta}_{i+}} (pooled over columns) to the overall weighted mean.
Similarly, the column effect test compares \eqn{\log \bar{\theta}_{+j}}
(pooled over rows). The residual tests whether the cell log odds ratios
\eqn{\log \theta_{ij}} are additive in the row and column effects.

\strong{Note:} The two-way ANOVA-like decomposition for 4-dimensional tables
appears to be a novel extension introduced in this package. The existing
literature on the Woolf test (and related Breslow-Day test) treats strata
as unstructured, testing only whether all \eqn{k} odds ratios are equal.
This decomposition exploits the factorial structure of \eqn{R \times C}{R x C}
strata to provide more detailed insight into the sources of heterogeneity.
}
\examples{
# 3-way tables
data(CoalMiners, package = "vcd")
woolf_test(CoalMiners)

data(Heart, package = "vcdExtra")
woolf_test(Heart)

# 4-way table without decomposition
data(Fungicide, package = "vcdExtra")
woolf_test(Fungicide)

# 4-way table with decomposition
woolf_test(Fungicide, decompose = TRUE)

# 4-way table, but need to rearrange dimensions
# How does association between `Preference` and `M_User` vary over strata?
data(Detergent, package = "vcdExtra")
dimnames(Detergent) |> names()
Detergent <- aperm(Detergent, c(3, 2, 1, 4))
woolf_test(Detergent)


}
\references{
Woolf, B. (1955). On estimating the relation between blood group and disease.
\emph{Annals of Human Genetics}, \bold{19}, 251-253.
}
\seealso{
\code{\link[stats]{mantelhaen.test}}, \code{\link[DescTools]{BreslowDayTest}}

Other association tests: 
\code{\link{CMHtest}()},
\code{\link{GKgamma}()},
\code{\link{HLtest}()},
\code{\link{zero.test}()}
}
\concept{association tests}
