% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.unityfor.R
\name{predict.unityfor}
\alias{predict.unityfor}
\title{Unity Forest prediction}
\usage{
\method{predict}{unityfor}(
  object,
  data = NULL,
  predict.all = FALSE,
  num.trees = object$num.trees,
  type = "response",
  num.threads = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{\code{unityfor} object.}

\item{data}{New test data of class \code{data.frame}.}

\item{predict.all}{Return individual predictions for each tree instead of aggregated predictions for all trees. Return a matrix (sample x tree) for classification and continuous outcomes, and a 3d array for probability estimation (sample x class x tree).}

\item{num.trees}{Number of trees used for prediction. The first \code{num.trees} in the forest are used.}

\item{type}{Type of prediction. Either 'response' (default) or 'terminalNodes'. See below for details.}

\item{num.threads}{Number of threads to use.
The default is to use at most 2 threads (and at most the number of available CPU cores).
This conservative default avoids unintentionally using many cores on shared computing resources
(e.g., CI systems, servers, or HPC login/compute nodes).

For typical use on a personal computer, setting \code{num.threads = 0} is strongly recommended,
as it uses all available CPU cores, which typically substantially reduces runtime.}

\item{verbose}{Verbose output on or off.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Object of class \code{unityfor.prediction} with elements
  \tabular{ll}{
      \code{predictions}    \tab Predicted classes/probabilities/values/terminal nodes  \cr
      \code{num.trees}   \tab Number of trees. \cr
      \code{num.independent.variables} \tab Number of independent variables. \cr
      \code{treetype}    \tab Type of forest/tree. Categorical or continuous outcome. \cr
      \code{num.samples}     \tab Number of samples.
  }
}
\description{
Prediction with new data and a saved forest from \code{\link{unityfor}}.
}
\details{
For \code{type = 'response'} (the default), the predicted probabilities (probability estimation), predicted classes (classification), or predicted numeric values (continuous outcomes) are returned. 
For \code{type = 'terminalNodes'}, the IDs of the terminal node in each tree for each observation in the given dataset are returned.
}
\references{
\itemize{
  \item Hornung, R., Hapfelmeier, A. (2026). Unity Forests: Improving Interaction Modelling and Interpretability in Random Forests. arXiv:2601.07003, <\doi{10.48550/arXiv.2601.07003}>.
  \item Wright, M. N., Ziegler, A. (2017). ranger: A fast Implementation of Random Forests for High Dimensional Data in C++ and R. Journal of Statistical Software 77:1-17, <\doi{10.18637/jss.v077.i01}>.
  }
}
\seealso{
\code{\link{unityfor}}
}
\author{
Marvin N. Wright, Roman Hornung
}
