# -------------------------------------------------------------------------------
#   This file is part of 'unityForest'.
#
# 'unityForest' is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# 'unityForest' is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with 'unityForest'. If not, see <http://www.gnu.org/licenses/>.
#
#  NOTE: 'unityForest' is a fork of the popular R package 'ranger', written by Marvin N. Wright.
#  Most R and C++ code is identical with that of 'ranger'. The package 'unityForest'
#  was written by taking the original 'ranger' code and making any
#  changes necessary to implement unity forests.
#
# -------------------------------------------------------------------------------

# Print contents of \code{unityfor} object.
#' @author Roman Hornung, Marvin N. Wright
#' @export
print.unityfor <- function(x, ...) {
  cat("unityfor result\n\n")
  cat("Call:\n", deparse(x$call), "\n\n")
  cat("Type:                            ", x$treetype, "\n")
  cat("Number of trees:                 ", x$num.trees, "\n")
  cat("Sample size:                     ", x$num.samples, "\n")
  cat("Number of independent variables: ", x$num.independent.variables, "\n")
  cat("Prop.var.root:                   ", x$prop.var.root, "\n")
  cat("Maximum tree root depth:         ", x$max.depth.root, "\n")
  cat("Variable importance mode:        ", x$importance.mode, "\n")
  cat("Mtry used for tree sprouts:      ", x$mtry, "\n")
  if (!is.null(x$variable.importance)) {
  cat("prop.best.splits:                ", x$prop.best.splits)
  }
  cat("Splitrule:                       ", x$splitrule, "\n")
  if (x$treetype == "Classification") {
    cat("OOB prediction error:            ", sprintf("%1.2f %%", 100*x$prediction.error), "\n")
  } else if (x$treetype == "Regression") {
    cat("OOB prediction error (MSE):      ", x$prediction.error, "\n")
  } else if (x$treetype == "Probability estimation") {
    cat("OOB prediction error (Brier s.): ", x$prediction.error, "\n")
  } else {
    cat("OOB prediction error:            ", x$prediction.error, "\n")
  }
  if (x$treetype == "Regression") {
    cat("R squared (OOB):                 ", x$r.squared, "\n")
  }
}

# Print contents of \code{unityfor.forest} object.
#' @author Marvin N. Wright
#' @export
print.unityfor.forest <- function(x, ...) {
  cat("unityfor forest object\n\n")
  cat("Type:                         ", x$treetype, "\n")
  cat("Number of trees:              ", x$num.trees, "\n")
}

# Print contents of \code{interactionfor.prediction} object.
#' @author Marvin N. Wright
#' @export
print.unityfor.prediction <- function(x, ...) {
  cat("unityfor prediction\n\n")
  cat("Type:                            ", x$treetype, "\n")
  cat("Sample size:                     ", x$num.samples, "\n")
  cat("Number of independent variables: ", x$num.independent.variables, "\n")
}

# Print contents of \code{unityfor.reprTrees}  object.
#' @author Roman Hornung
#' @export
print.unityfor.reprTrees <- function(x, ...) {
  cat("Covariate-representative tree roots result\n\n")
  cat("Considered variables: ", paste(x$var.names, collapse=", "), "\n")
  cat("Type:                 ", x$treetype, "\n")
}
