% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chemical_summary.R
\name{get_chemical_summary}
\alias{get_chemical_summary}
\title{Compute EAR values}
\usage{
get_chemical_summary(
  tox_list,
  ACC = NULL,
  filtered_ep = "All",
  chem_data = NULL,
  chem_site = NULL,
  chem_info = NULL,
  exclusion = NULL
)
}
\arguments{
\item{tox_list}{List with data frames for chem_data, chem_info, chem_site,
and optionally exclusions and benchmarks. Created with \code{\link{create_toxEval}}.}

\item{ACC}{Data frame with columns: CAS, chnm, endPoint, and ACC_value
for specific chemical/endpoint combinations generated using the
\code{\link{get_ACC}} function. EndPoints with specific data quality flags
may optionally be removed using the \code{\link{remove_flags}} function.}

\item{filtered_ep}{Data frame with columns: endPoints, groupCol. Default is \code{"All"}, where no
filtering occurs.}

\item{chem_data}{\emph{Optional} data frame with (at least) columns: CAS, SiteID, and Value. Default is \code{NULL}.
The argument will over-ride what is in tox_list.}

\item{chem_site}{\emph{Optional} data frame with (at least) columns: SiteID, and Short Name. Default is \code{NULL}.
The argument will over-ride what is in tox_list.}

\item{chem_info}{\emph{Optional} data frame with (at least) columns: CAS, and class. Default is \code{NULL}.
The argument will over-ride what is in tox_list.}

\item{exclusion}{\emph{Optional} data frame with (at least) columns: CAS and endPoint. Default is \code{NULL}.
The argument will over-ride what is in tox_list.}
}
\value{
a data frame with the columns: CAS, chnm (chemical name
as a factor), site, date, EAR, Bio_category, shortName (of site), Class. The output of this
function is where you find EAR values for every chemical/endpoint combination.
}
\description{
This function computes Exposure:Activity ratios using user-provided measured
concentration data from the output of \code{\link{create_toxEval}},
and joins the data with the activity concentration at cutoff data provided by
ToxCast.Data from ToxCast is included with this package, but alternative
benchmark data can be provided to perform the same "toxEval" analysis.
}
\details{
To use the data provided by the package, a sample workflow is shown below
in the examples. The examples include retrieving the ToxCast (ACC) values
that are used to calculate EARs, choosing endPoints that should be ignored
based on data quality "flags" in the ToxCast database, and removing groups of
endPoints that may not be important to the analysis at hand.
}
\examples{
path_to_tox <- system.file("extdata", package = "toxEval")
file_name <- "OWC_data_fromSup.xlsx"
full_path <- file.path(path_to_tox, file_name)

tox_list <- create_toxEval(full_path)

ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)

chemical_summary <- get_chemical_summary(tox_list, ACC, filtered_ep)
head(chemical_summary)
}
