% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-upsampling.R
\name{nn_upsample}
\alias{nn_upsample}
\title{Upsample module}
\usage{
nn_upsample(
  size = NULL,
  scale_factor = NULL,
  mode = "nearest",
  align_corners = NULL
)
}
\arguments{
\item{size}{(int or \code{Tuple[int]} or \code{Tuple[int, int]} or \code{Tuple[int, int, int]}, optional):
output spatial sizes}

\item{scale_factor}{(float or \code{Tuple[float]} or \code{Tuple[float, float]} or \code{Tuple[float, float, float]}, optional):
multiplier for spatial size. Has to match input size if it is a tuple.}

\item{mode}{(str, optional): the upsampling algorithm: one of \code{'nearest'},
\code{'linear'}, \code{'bilinear'}, \code{'bicubic'} and \code{'trilinear'}.
Default: \code{'nearest'}}

\item{align_corners}{(bool, optional): if \code{TRUE}, the corner pixels of the input
and output tensors are aligned, and thus preserving the values at
those pixels. This only has effect when \code{mode} is
\code{'linear'}, \code{'bilinear'}, or \code{'trilinear'}. Default: \code{FALSE}}
}
\description{
Upsamples a given multi-channel 1D (temporal), 2D (spatial) or 3D (volumetric) data.
The input data is assumed to be of the form minibatch x channels x optional depth x
optional height] x width. Hence, for spatial inputs, we expect a 4D Tensor and for
volumetric inputs, we expect a 5D Tensor.
}
\details{
The algorithms available for upsampling are nearest neighbor and linear, bilinear,
bicubic and trilinear for 3D, 4D and 5D input Tensor, respectively.

One can either give a scale_factor or the target output size to calculate the
output size. (You cannot give both, as it is ambiguous)
}
\examples{
if (torch_is_installed()) {
input <- torch_arange(start = 1, end = 4, dtype = torch_float())$view(c(1, 1, 2, 2))
nn_upsample(scale_factor = c(2), mode = "nearest")(input)
nn_upsample(scale_factor = c(2, 2), mode = "nearest")(input)
}
}
