% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{reprune}
\alias{reprune}
\alias{reprune.group_tna}
\title{Restore Previous Pruning of a Transition Network Analysis Model}
\usage{
reprune(x, ...)

\method{reprune}{group_tna}(x, ...)
}
\arguments{
\item{x}{A \code{tna} or \code{group_tna} object.}

\item{...}{Ignored.}
}
\value{
A \code{tna} or \code{group_tna} object that has not been pruned. The previous
pruning result can be reactivated with \code{\link[=reprune]{reprune()}}.
}
\description{
Restore Previous Pruning of a Transition Network Analysis Model
}
\examples{
model <- tna(group_regulation)
pruned_model <- prune(model, method = "threshold", threshold = 0.1)
depruned_model <- deprune(pruned_model) # restore original model
repruned_model <- reprune(depruned_model) # reapply the previous pruning

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
