% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_comparison}
\alias{plot.tna_comparison}
\title{Plot the Comparison of Two TNA Models or Matrices}
\usage{
\method{plot}{tna_comparison}(
  x,
  type = "heatmap",
  population = "difference",
  method = "pearson",
  name_x = "x",
  name_y = "y",
  ...
)
}
\arguments{
\item{x}{A \code{tna_comparison} object.}

\item{type}{A \code{character} string naming the type of plot to produce. The
available options are \code{"heatmap"} (the default), \code{"scatterplot"},
\code{"centrality_heatmap"}, and \code{"weight_density"}.}

\item{population}{A \code{"character"} string naming the population for which
to produce the heatmaps, i.e, one of \code{"x"}, \code{"y"}, or \code{"difference"} for
the differences. Ignored for \code{type = "scatterplot"}. Defaults to \code{"diff"}.}

\item{method}{A \code{character} string naming the correlation coefficient to
use when plotting a scatterplot. The available options are \code{"pearson"}
(the default), \code{"kendall"}, \code{"spearman"}, and \code{"distance"}. The final
option is the distance correlation coefficient of
Szekely, Rizzo, and Bakirov (2007). See also the \code{energy} package for
further information on this measure.}

\item{name_x}{An optional \code{character} string to use as the name of the
first population in the plots. The default is \code{"x"}.}

\item{name_y}{An optional \code{character} string to use as the name of the
second population in the plots. The default is \code{"y"}.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the Comparison of Two TNA Models or Matrices
}
\examples{
model_x <- tna(group_regulation[1:200, ])
model_y <- tna(group_regulation[1001:1200, ])
comp <- compare(model_x, model_y)
plot(comp)

}
\references{
Szekely, G.J., Rizzo, M.L., and Bakirov, N.K. (2007),
Measuring and Testing Dependence by Correlation of Distances,
\emph{Annals of Statistics}, 35(6), 2769-2794.
doi:10.1214/009053607000000505
}
\seealso{
Model comparison functions
\code{\link{compare}()},
\code{\link{compare.group_tna}()},
\code{\link{compare_sequences}()},
\code{\link{plot.tna_sequence_comparison}()},
\code{\link{plot_compare}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{print.tna_comparison}()},
\code{\link{print.tna_sequence_comparison}()}
}
\concept{comparison}
