% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralities.R
\name{estimate_cs}
\alias{estimate_cs}
\alias{estimate_centrality_stability}
\alias{estimate_cs.tna}
\alias{estimate_centrality_stability.tna}
\alias{estimate_cs.group_tna}
\alias{estimate_centrality_stability.group_tna}
\title{Estimate Centrality Stability}
\usage{
estimate_cs(
  x,
  loops,
  normalize,
  invert,
  measures,
  iter,
  method,
  drop_prop,
  threshold,
  certainty,
  progressbar
)

estimate_centrality_stability(
  x,
  loops,
  normalize,
  invert,
  measures,
  iter,
  method,
  drop_prop,
  threshold,
  certainty,
  progressbar
)

\method{estimate_cs}{tna}(
  x,
  loops = FALSE,
  normalize = FALSE,
  invert = TRUE,
  measures = c("InStrength", "OutStrength", "Betweenness"),
  iter = 1000,
  method = "pearson",
  drop_prop = seq(0.1, 0.9, by = 0.1),
  threshold = 0.7,
  certainty = 0.95,
  progressbar = FALSE
)

\method{estimate_centrality_stability}{tna}(
  x,
  loops = FALSE,
  normalize = FALSE,
  invert = TRUE,
  measures = c("InStrength", "OutStrength", "Betweenness"),
  iter = 1000,
  method = "pearson",
  drop_prop = seq(0.1, 0.9, by = 0.1),
  threshold = 0.7,
  certainty = 0.95,
  progressbar = FALSE
)

\method{estimate_cs}{group_tna}(
  x,
  loops = FALSE,
  normalize = FALSE,
  invert = TRUE,
  measures = c("InStrength", "OutStrength", "Betweenness"),
  iter = 1000,
  method = "pearson",
  drop_prop = seq(0.1, 0.9, by = 0.1),
  threshold = 0.7,
  certainty = 0.95,
  progressbar = FALSE
)

\method{estimate_centrality_stability}{group_tna}(
  x,
  loops = FALSE,
  normalize = FALSE,
  invert = TRUE,
  measures = c("InStrength", "OutStrength", "Betweenness"),
  iter = 1000,
  method = "pearson",
  drop_prop = seq(0.1, 0.9, by = 0.1),
  threshold = 0.7,
  certainty = 0.95,
  progressbar = FALSE
)
}
\arguments{
\item{x}{A \code{tna} or a \code{group_tna} object representing the temporal network
analysis data. The object should be created from a sequence data object.}

\item{loops}{A \code{logical} value indicating whether to include loops in the
network when computing the centrality measures. The default is \code{FALSE}.}

\item{normalize}{A \code{logical} value indicating whether to normalize
the centrality measures. The default is \code{FALSE}.}

\item{invert}{A \code{logical} value indicating whether the weights should be
inverted for distance-based measures. The default is \code{TRUE}.}

\item{measures}{A \code{character} vector of centrality measures to estimate.
The default measures are \code{"InStrength"}, \code{"OutStrength"},
and \code{"Betweenness"}. See \code{\link[=centralities]{centralities()}} for a list of available
centrality measures.}

\item{iter}{An \code{integer} specifying the number of resamples to draw.
The default is 1000.}

\item{method}{A \code{character} string indicating the correlation coefficient
type. The default is \code{"pearson"}. See \code{\link[stats:cor]{stats::cor()}} for details.}

\item{drop_prop}{A \code{numeric} vector specifying the proportions of
cases to drop in each sampling iteration. Default is a sequence from 0.1
to 0.9 in increments of 0.1.}

\item{threshold}{A \code{numeric} value specifying the correlation threshold for
calculating the CS-coefficient. The default is 0.7.}

\item{certainty}{A \code{numeric} value specifying the desired level of certainty
for the CS-coefficient. Default is 0.95.}

\item{progressbar}{A \code{logical} value. If \code{TRUE}, a progress bar is displayed
Defaults to \code{FALSE}}
}
\value{
A \code{tna_stability} object which is a \code{list} with an element for each
\code{measure} with the following elements:
\itemize{
\item \code{cs_coefficient}: The centrality stability (CS) coefficient
of the measure.
\item \code{correlations}: A \code{matrix} of correlations between the original
centrality and the resampled centralities for each drop proportion.
}

If \code{x} is a \code{group_tna} object, a \code{group_tna_stability} object is returned
instead, which is a \code{list} of \code{tna_stability} objects.
}
\description{
Estimates the stability of centrality measures in a network
using subset sampling without replacement. It allows for dropping varying
proportions of cases and calculates correlations between the original
centralities and those computed using sampled subsets.
}
\details{
The function works by repeatedly resampling the data, dropping varying
proportions of cases, and calculating centrality measures on the subsets.
The correlation between the original centralities and the resampled
centralities is calculated for each drop proportion. The stability of each
centrality measure is then summarized using a centrality stability (CS)
coefficient, which represents the proportion of dropped cases at which
the correlations drop below a given threshold (default 0.7).

The results can be visualized by plotting the output object showing the
stability of the centrality measures across different drop proportions,
along with confidence intervals. The CS-coefficients are displayed in the
subtitle.
}
\examples{
model <- tna(group_regulation)
# Small number of iterations and drop proportions for CRAN
estimate_cs(
  model,
  drop_prop = seq(0.3, 0.9, by = 0.2),
  measures = c("InStrength", "OutStrength"),
  iter = 10
)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
