% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{cluster_data}
\alias{cluster_data}
\alias{cluster_sequences}
\title{Clustering via Dissimilarity Matrix based on String Distances}
\usage{
cluster_data(
  data,
  k,
  dissimilarity = "hamming",
  method = "pam",
  na_syms = c("*", "\%"),
  weighted = FALSE,
  lambda = 1,
  ...
)

cluster_sequences(
  data,
  k,
  dissimilarity = "hamming",
  method = "pam",
  na_syms = c("*", "\%"),
  weighted = FALSE,
  lambda = 1,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{matrix} in wide format.}

\item{k}{An \code{integer} giving the number of clusters.}

\item{dissimilarity}{A \code{character} string specifying the
dissimilarity measure. The available options are: \code{"osa"}, \code{"lv"}, \code{"dl"},
\code{"hamming"}, \code{"lcs"}, \code{"qgram"}, \code{"cosine"}, \code{"jaccard"}, and \code{"jw"}.
See \link[stringdist:stringdist-metrics]{stringdist::stringdist-metrics} for more information on
these measures.}

\item{method}{A \code{character} string specifying clustering method.
The available methods are \code{"pam"}, \code{"ward.D"}, \code{"ward.D2"},
\code{"complete"},\code{"average"}, \code{"single"}, \code{"mcquitty"}, \code{"median"}, and
\code{"centroid"}. See \code{\link[cluster:pam]{cluster::pam()}} and \code{\link[stats:hclust]{stats::hclust()}} for more
information on these methods.}

\item{na_syms}{A \code{character} vector of symbols or factor levels to convert
to explicit missing values.}

\item{weighted}{A \code{logical} value indicating whether the dissimilarity
measure should be weighted (the default is \code{FALSE} for no weighting).
If \code{TRUE}, earlier observations of the sequences receive a greater weight
in the distance calculation with an exponential decay. Currently only
supported for the Hamming distance.}

\item{lambda}{A \code{numeric} value defining the strength of the decay when
\code{weighted = TRUE}. The default is \code{1.0}.}

\item{...}{Additional arguments passed to \code{\link[stringdist:stringdist]{stringdist::stringdist()}}.}
}
\value{
A \code{tna_clustering} object which is a  \code{list} containing:
\itemize{
\item \code{data}: The original data.
\item \code{k}: The number of clusters.
\item \code{assignments}: An \code{integer} vector of cluster assignments.
\item \code{silhouette}: Silhouette score measuring clustering quality.
\item \code{sizes}: An \code{integer} vector of cluster sizes.
\item \code{method}: The clustering method used.
\item \code{distance}: The distance matrix.
}
}
\description{
Performs clustering using specified dissimilarity measures
and clustering methods. The rows of the data are first converted to strings
and compared using the dissimilarity measures available in the
\code{stringdist} package.
}
\examples{
data <- data.frame(
  T1 = c("A", "B", "A", "C", "A", "B"),
  T2 = c("B", "A", "B", "A", "C", "A"),
  T3 = c("C", "C", "A", "B", "B", "C")
)

# PAM clustering with optimal string alignment (default)
result <- cluster_sequences(data, k = 2)

}
