% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toy_ldata.R
\docType{data}
\name{toy_ldata}
\alias{toy_ldata}
\title{Toy multiplexed imaging data for examples}
\format{
A named list with one element:
\describe{
\item{ToySample}{A data frame with columns:
\itemize{
\item x: x-coordinate in microns
\item y: y-coordinate in microns
\item coarse_phen_vec: Cell phenotype ("B cells", "T cells", or "Other")
\item row_index: Integer row index (1 to nrow)
\item cflag: Integer flag column (0 for all cells)
}
}
}
}
\usage{
toy_ldata
}
\description{
A small synthetic dataset mimicking multiplexed tissue imaging data.
It contains one sample named "ToySample" with columns required by tlsR functions.
}
\examples{
data(toy_ldata)
str(toy_ldata[["ToySample"]])
plot(toy_ldata[["ToySample"]]$x, toy_ldata[["ToySample"]]$y,
     col = as.factor(toy_ldata[["ToySample"]]$coarse_phen_vec),
     pch = 19, cex = 0.5, main = "Toy sample cells")
}
\keyword{datasets}
