% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{adapt_timeseries}
\alias{adapt_timeseries}
\title{Adapt time-series dataframe to timezone, date range and fill gaps}
\usage{
adapt_timeseries(dtf, start_date, end_date, tzone = NULL, fill_gaps = FALSE)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{start_date}{Date, start date of the output datetime sequence}

\item{end_date}{Date, end date of the output datetime sequence (included)}

\item{tzone}{character, desired time-zone of the datetime sequence.
If NULL, the timezone of \code{dtf$datetime} is kept.}

\item{fill_gaps}{boolean, whether to fill gaps based on
same weekday and hour from past data (See \code{fill_from_past} function).}
}
\value{
tibble
}
\description{
This function adapts the date range of a time series by reusing historical
patterns based on the same weekday occurrence within the year and decimal
hour of the day. It also can fill gaps in the data based on past data,
so it is recommended to use it for time series with weekly or yearly patterns
(so for example energy demand but not solar generation).
It can also adapt the timezone of the time series, for example if the data
was stored in UTC but corresponds to a different timezone.
}
\examples{
# Example data set
print(dtf)

# Original date range
range(dtf$datetime)

dtf2 <- adapt_timeseries(
  dtf,
  start_date = as.Date("2021-01-01"),
  end_date = as.Date("2021-01-31"),
  tzone = "America/New_York",
  fill_gaps = FALSE
)

# New date range
range(dtf2$datetime)

}
