% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tikatuwq-package.R
\docType{package}
\name{tikatuwq-package}
\alias{tikatuwq}
\alias{tikatuwq-package}
\title{tikatuwq: Water quality tools for the Brazilian context}
\description{
Utilities to import, clean, validate and analyze freshwater quality data.
Includes indices (IQA/WQI, TSI/IET Carlson and Lamparelli), compliance
checks against CONAMA 357/2005, visualizations, and rule-based analytical text.
}
\section{Main features}{

\itemize{
\item \strong{Indices}: IQA/WQI; TSI/IET (Carlson, Lamparelli); NSF WQI prototype.
\item \strong{Compliance}: CONAMA 357/2005 limits and per-record status.
\item \strong{Visualization}: time series, boxplots, heatmap, IQA bars.
\item \strong{Reporting}: simple Rmd/Quarto report; analytical paragraphs (rule-based).
}
}

\section{Quick start}{

\preformatted{
# demo data
data(wq_demo)

# compute IQA
d1 <- iqa(wq_demo, na_rm = TRUE)

# check compliance (CONAMA class "2")
d2 <- conama_check(d1, classe = "2")

# summary table (only violations)
conama_report(d2, classe = "2", only_violations = TRUE)
}
}

\section{Vignettes}{

See the package website for walkthroughs and examples:
\href{https://tikatuwq.github.io/tikatuwq/}{tikatuwq website}.
}

\references{
Carlson (1977) \url{doi:10.4319/lo.1977.22.2.0361}
Lamparelli (2004) \url{https://www.teses.usp.br/teses/disponiveis/41/41134/tde-20032006-075813/publico/TeseLamparelli2004.pdf}
NSF WQI \url{https://link.springer.com/article/10.1007/s11157-023-09650-7}
CONAMA 357/2005 \url{https://conama.mma.gov.br/?id=450&option=com_sisconama&task=arquivo.download}
}
\seealso{
\code{\link[=read_wq]{read_wq()}}, \code{\link[=conama_check]{conama_check()}}, \code{\link[=iqa]{iqa()}},
\code{\link[=iet_carlson]{iet_carlson()}}, \code{\link[=iet_lamparelli]{iet_lamparelli()}},
\code{\link[=plot_series]{plot_series()}}, \code{\link[=render_report]{render_report()}}
}
\author{
\strong{Maintainer}: Vinicius Saraiva Santos \email{vinisaraiva@gmail.com} (\href{https://orcid.org/0009-0007-1387-7927}{ORCID})

}
\keyword{internal}
