% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_check_pid.R
\name{tw_check_pid}
\alias{tw_check_pid}
\title{Ensures that input appears to be a valid Wikidata property id (i.e. it starts
with P and is followed only by digits)}
\usage{
tw_check_pid(property, logical_vector = FALSE, non_pid_as_NA = FALSE)
}
\arguments{
\item{property}{A character vector of one or more Wikidata property
identifiers.}

\item{logical_vector}{Logical, defaults to \code{FALSE}. If \code{TRUE}, returns a
logical vector of the same length as input, where \code{TRUE} corresponds to
seemingly meaningful property identifiers.}

\item{non_pid_as_NA}{Logical, defaults to \code{FALSE}. If \code{TRUE} (and if
\code{logical_vector} is set to \code{FALSE}), a vector of the same length is
returned, with \code{NA} replacing items that are seemingly not meaningful
property identifiers.}
}
\value{
A character vector with only strings appearing to be Wikidata
identifiers; possibly shorter than input.
}
\description{
Mostly used internally by other functions.
}
\examples{

tw_check_pid(property = c("P19", "p20", "Not an property id", "20", NA, "Q5", ""))

tw_check_pid(
  property = c("P19", "p20", "Not an property id", "20", NA, "Q5", ""),
  logical_vector = TRUE
)

tw_check_pid(
  property = c("P19", "p20", "Not an property id", "20", NA, "Q5", ""),
  non_pid_as_NA = TRUE
)
}
