% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_level_to_na.R
\name{convert_level_to_na}
\alias{convert_level_to_na}
\title{Convert \code{"NA"} values to \code{NA} for categorical variables}
\usage{
convert_level_to_na(data)
}
\arguments{
\item{data}{A data frame or tibble}
}
\value{
A data frame or tibble with \code{"NA"} converted to \code{NA}
}
\description{
Convert \code{"NA"} values to \code{NA} for categorical variables
}
\examples{

data <- data.frame(
  x1 = c(1, 2, NA),  
  x2 = c("1", "2", "NA"),
  x3 = factor(c("1", "2", "NA")),
  x4 = factor(c("b", "NA", "a"), ordered = TRUE)
)

convert_level_to_na(data)

}
