% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_grm.R
\name{pairwise_grm}
\alias{pairwise_grm}
\title{Compute the Genomic Relationship Matrix for a \code{gen_tibble} object}
\usage{
pairwise_grm(
  x,
  allele_sharing_mat = NULL,
  block_size = bigstatsr::block_size(nrow(x))
)
}
\arguments{
\item{x}{a \code{gen_tibble} object.}

\item{allele_sharing_mat}{optional, the matrix of Allele Sharing returned by
\code{\link[=pairwise_allele_sharing]{pairwise_allele_sharing()}} with \code{as_matrix=TRUE}. As a number of
statistics can be derived from the Allele Sharing matrix, it it sometimes
more efficient to pre-compute this matrix.}

\item{block_size}{the size of the blocks to use for the computation of the
allele sharing matrix.}
}
\value{
a matrix of GR between all pairs of individuals
}
\description{
This function computes the Genomic Relationship Matrix (GRM). This is
estimated by computing the pairwise kinship coefficients (coancestries)
between all pairs of individuals from a matrix of Allele Sharing following
the approach of Weir and Goudet 2017 based on beta estimators).
}
\details{
The GRM is twice the coancestry matrix (e.g. as estimated by
\code{hierfstat::beta.dosage()} with \code{inb=FALSE}).
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Compute the GRM from the allele sharing matrix
example_gt \%>\% pairwise_grm()

# To calculate using a precomputed allele sharing matrix, use:
allele_sharing <- example_gt \%>\% pairwise_allele_sharing(as_matrix = TRUE)
example_gt \%>\% pairwise_grm(allele_sharing_mat = allele_sharing)
}
