% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indiv_het_obs.R
\name{indiv_het_obs}
\alias{indiv_het_obs}
\alias{indiv_het_obs.tbl_df}
\alias{indiv_het_obs.vctrs_bigSNP}
\title{Estimate individual observed heterozygosity}
\usage{
indiv_het_obs(.x, as_counts = FALSE, ...)

\method{indiv_het_obs}{tbl_df}(.x, as_counts = FALSE, ...)

\method{indiv_het_obs}{vctrs_bigSNP}(.x, as_counts = FALSE, ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{as_counts}{logical, if \code{TRUE}, return a matrix with two columns:
the number of heterozygotes and the number of missing values for each
individual. These quantities can be useful to compute more complex
quantities.}

\item{...}{currently unused.}
}
\value{
either:
\itemize{
\item a vector of heterozygosities, one per individuals in the \code{\link{gen_tibble}}
\item a matrix with two columns, where the first is the number of heterozygous
loci for each individual and the second is the number of missing values
for each individual
}
}
\description{
Estimate observed heterozygosity (H_obs) for each individual (i.e. the
frequency of loci that are heterozygous in an individual).
}
\examples{
example_gt <- load_example_gt("gen_tbl")

example_gt \%>\% indiv_het_obs()

# For observed heterozygosity as counts:
example_gt \%>\% indiv_het_obs(as_counts = TRUE)

}
