% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_load.R
\name{gt_load}
\alias{gt_load}
\title{Load a gen_tibble}
\usage{
gt_load(file = NULL, reattach_to = NULL)
}
\arguments{
\item{file}{the file name, including the full path. If it does not end with
\emph{.gt}, the extension will be added.}

\item{reattach_to}{the file name, including the full path, of the \emph{.rds} file
if it was moved. It assumes that the \emph{.bk} file is found in the same path.
You should be able to leave this to NULL unless you have moved the files.}
}
\value{
a \code{\link{gen_tibble}}
}
\description{
Load a \code{gen_tibble} previously saved with \code{\link[=gt_save]{gt_save()}}. If the \emph{.rds} and
\emph{.bk} files have not
been moved, they should be found automatically. If they were moved, use
\code{reattach_to} to point to the \emph{.rds} file (the \emph{.bk} file needs to be in the
same directory as the \emph{.rds} file).
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# remove some individuals
example_gt_filtered <- example_gt \%>\% filter(id != "a")

# save the filtered gen_tibble object
backing_files <- gt_save(example_gt_filtered,
  file_name = paste0(tempfile(), "_example_filtered")
)

# backing_files[1] contains the name of the saved .gt file
backing_files[1]

# To load the saved gen_tibble object, use the path to the saved .gt file
reloaded_gt <- gt_load(backing_files[1])

# And we have loaded the gt without individual "a"
reloaded_gt
}
\seealso{
\code{\link[=gt_save]{gt_save()}}
}
