% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_gt_admix.R
\name{autoplot_gt_admix}
\alias{autoplot_gt_admix}
\alias{autoplot.gt_admix}
\title{Autoplots for \code{gt_admix} objects}
\usage{
\method{autoplot}{gt_admix}(object, type = c("cv", "barplot"), k = NULL, run = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{gt_admixture}}

\item{type}{the type of plot (one of "cv", and "barplot")}

\item{k}{the value of \code{k} to plot (for \code{barplot} type only) param repeat the
repeat to plot (for \code{barplot} type only)}

\item{run}{the run to plot (for \code{barplot} type only)}

\item{...}{additional arguments to be passed to autoplot method for
q_matrices \code{\link[=autoplot_q_matrix]{autoplot_q_matrix()}}, used when type is \code{barplot}.}
}
\value{
a \code{ggplot2} object
}
\description{
For \code{gt_admix}, the following types of plots are available:
\itemize{
\item \code{cv}: the cross-validation error for each value of \code{k}
\item \code{barplot} a standard barplot of the admixture proportions
}
}
\details{
\code{autoplot} produces simple plots to quickly inspect an object. They are not
customisable; we recommend that you use \code{ggplot2} to produce publication
ready plots.

This autoplot will automatically rearrange individuals according to their id
and any grouping variables if an associated 'data' gen_tibble is provided. To
avoid any automatic re-sorting of individuals, set \code{arrange_by_group} and
\code{arrange_by_indiv} to FALSE. See \code{autoplot.q_matrix} for further details.
}
\examples{
# Read example gt_admix object
admix_obj <-
  readRDS(system.file("extdata", "anolis", "anole_adm_k3.rds",
    package = "tidypopgen"
  ))
# Cross-validation plot
autoplot(admix_obj, type = "cv")

# Basic barplot
autoplot(admix_obj, k = 3, run = 1, type = "barplot")

# Barplot with individuals arranged by Q proportion
# (using additional arguments, see `autoplot.q_matrix` for details)
autoplot(admix_obj,
  k = 3, run = 1, type = "barplot", annotate_group = TRUE,
  arrange_by_group = TRUE, arrange_by_indiv = TRUE,
  reorder_within_groups = TRUE
)

}
