% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pcadapt.R
\name{gt_pcadapt}
\alias{gt_pcadapt}
\title{pcadapt analysis on a \code{gen_tibble} object}
\usage{
gt_pcadapt(x, pca, k, n_cores = 1)
}
\arguments{
\item{x}{A \code{gen_tibble} object.}

\item{pca}{a \code{\link{gt_pca}} object, as returned by \code{gt_pca_partialSVD()} or
\code{gt_pca_randomSVD()}.}

\item{k}{Number of principal components to use in the analysis.}

\item{n_cores}{Number of cores to use.}
}
\value{
An object of subclass \code{gt_pcadapt}, a subclass of \code{mhtest}.
}
\description{
pcadapt is an algorithm that detects genetic markers under selection. It is
based on the principal component analysis (PCA) of the genotypes of the
individuals. The method is described in Luu et al. (2017). See the R package
\code{pcadapt}, which provides extensive documentation and examples.
}
\details{
Internally, this function uses the \code{snp_pcadapt} function from the \code{bigsnpr}
package.
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA object
pca <- gt_pca_partialSVD(lobsters)

# Create a gt_pcadapt object
gt_pcadapt(lobsters, pca, k = 2)
\dontshow{\}) # examplesIf}
}
\references{
Luu, K., Bazin, E., Blum, M. G. B., & François, O. (2017).
pcadapt: an R package for genome scans for selection based on principal
component analysis. Molecular Ecology Resources, 17(1), 67–77.
}
