% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_loci_table_ordered.R
\name{find_duplicated_loci}
\alias{find_duplicated_loci}
\title{Find duplicates in the loci table}
\usage{
find_duplicated_loci(.x, error_on_false = FALSE, list_duplicates = TRUE, ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{error_on_false}{logical, if \code{TRUE} an error is thrown if duplicated
loci are found.}

\item{list_duplicates}{logical, if \code{TRUE} returns duplicated SNP names.}

\item{...}{other arguments passed to specific methods.}
}
\value{
if \code{list_duplicates} is TRUE, returns a vector of duplicated loci.
If \code{list_duplicates} is FALSE, returns a logical value indicating whether
there are any duplicated loci. If \code{error_on_false} is TRUE and there are
duplicates, an error is thrown.
}
\description{
This function finds duplicated SNPs by checking the positions within each
chromosome. It can return a list of duplicated SNPs or a logical value
indicating whether there are any duplicated loci.
}
\examples{
example_gt <- load_example_gt("gen_tbl")
show_loci(example_gt) <- test_loci <- data.frame(
  big_index = c(1:6),
  name = paste0("rs", 1:6),
  chromosome = paste0("chr", c(1, 1, 1, 1, 1, 1)),
  position = as.integer(c(3, 3, 5, 65, 343, 46)),
  genetic_dist = as.double(rep(0, 6)),
  allele_ref = c("A", "T", "C", "G", "C", "T"),
  allele_alt = c("T", "C", NA, "C", "G", "A"),
  chr_int = rep(1, 6)
)

show_loci(example_gt)

# Find which loci are duplicated
example_gt \%>\% find_duplicated_loci()
}
