% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-plot_addons.R
\name{layer_scores}
\alias{layer_scores}
\alias{plot_layer_scores}
\title{Add scores to a plot}
\usage{
layer_scores(
  object,
  mapping = NULL,
  which = "PC1",
  key = "param",
  value = "value",
  scores_geom = list(ggplot2::geom_path(), ggplot2::geom_point()),
  sequential_facets = TRUE
)

plot_layer_scores(
  object,
  mapping,
  which = "PC1",
  key = "param",
  value = "value",
  ...
)
}
\arguments{
\item{object}{A \link{nested_prcomp} or similar object}

\item{mapping}{A mapping created with \link[ggplot2:aes]{aes}}

\item{which}{Which principal components to plot}

\item{key}{The column name to use for the principal component names}

\item{value}{The column name to use for the principal component score values}

\item{scores_geom}{One or more geometries to which scores should be applied.}

\item{sequential_facets}{TRUE will result in the panel containing the dendrogram added to the right
of the plot.}

\item{...}{Passed to layer_scores()}
}
\value{
A \code{list()} that can be addeed to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Add scores to a plot
}
\examples{
library(ggplot2)
library(dplyr, warn.conflicts = FALSE)

alta_pca <- nested_data(
  alta_lake_geochem,
  qualifiers = c(age, depth, zone),
  key = param,
  value = value,
  trans = scale
) \%>\%
  nested_prcomp()

ggplot() +
  layer_scores(alta_pca, aes(value, depth), which = "PC1") +
  scale_y_reverse()

plot_layer_scores(alta_pca, aes(y = depth), which = c("PC1", "PC2")) +
  scale_y_reverse()

}
