% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row.R
\name{row-functions}
\alias{row-functions}
\alias{rowMeans}
\alias{rowSums}
\title{NA-aware Row-wise Functions}
\usage{
rowMeans(x, na.rm = TRUE, ...)

rowSums(x, na.rm = TRUE, dims = 1L, ...)
}
\arguments{
\item{x}{A numeric matrix or data frame.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}

\item{...}{Additional arguments passed to the base function.}

\item{dims}{Integer. Number of dimensions to treat as rows.}
}
\value{
A numeric or complex array of suitable size, or a vector if the
result is one-dimensional.
}
\description{
Drop-in replacements for \code{rowMeans()} and \code{rowSums()} that default to
\code{na.rm = TRUE}. Importantly, \code{rowSums()} returns \code{NA} for rows where
ALL values are missing.
}
\examples{
mat <- matrix(c(1, NA, 3, NA, NA, NA), nrow = 2, byrow = TRUE)
rowSums(mat)

# Compare to base R:
base::rowSums(mat, na.rm = TRUE)

}
