% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{tl_test_interactions}
\alias{tl_test_interactions}
\title{Test for significant interactions between variables}
\usage{
tl_test_interactions(
  data,
  formula,
  var1 = NULL,
  var2 = NULL,
  all_pairs = FALSE,
  categorical_only = FALSE,
  numeric_only = FALSE,
  mixed_only = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{data}{A data frame containing the data}

\item{formula}{A formula specifying the base model without interactions}

\item{var1}{First variable to test for interactions}

\item{var2}{Second variable to test for interactions (if NULL, tests var1 with all others)}

\item{all_pairs}{Logical; whether to test all variable pairs}

\item{categorical_only}{Logical; whether to only test categorical variables}

\item{numeric_only}{Logical; whether to only test numeric variables}

\item{mixed_only}{Logical; whether to only test numeric-categorical pairs}

\item{alpha}{Significance level for interaction tests}
}
\value{
A data frame with interaction test results
}
\description{
Test for significant interactions between variables
}
