% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curves_helpers.R
\name{available_curves}
\alias{available_curves}
\title{List available curve mnemonics in an index}
\usage{
available_curves(index, county = NULL, top_n = NULL)
}
\arguments{
\item{index}{Output of index_laslogs()}

\item{county}{Optional county filter (character vector)}

\item{top_n}{If not NULL, return only the top N most common curves}
}
\value{
Tibble with MNEM and n (count of wells containing the curve)
}
\description{
List available curve mnemonics in an index
}
\examples{
td <- tempdir()
f <- file.path(td, "a.las")

las_text <- c(
  " ~Version Information",
  " VERS. 2.0:",
  " WRAP. NO:",
  " ~Well Information",
  " STRT.M 1000:",
  " STOP.M 1001:",
  " STEP.M 1:",
  " NULL. -999.25:",
  " API . 1111111111:",
  " CNTY. TEST:",
  " ~Curve Information",
  " DEPT.M:",
  " GR.API:",
  " RHOB.G/C3:",
  " ~ASCII Log Data",
  " 1000 80 2.35",
  " 1001 82 2.36"
)

writeLines(las_text, f)
idx <- index_laslogs(td)
available_curves(idx, top_n = 5)
}
