% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.R
\name{pairwise_count_dt}
\alias{pairwise_count_dt}
\title{Count pairs of items within a group}
\usage{
pairwise_count_dt(
  .data,
  .group,
  .value,
  upper = FALSE,
  diag = FALSE,
  sort = TRUE
)
}
\arguments{
\item{.data}{A data.frame.}

\item{.group}{Column name of counting group.}

\item{.value}{Item to count pairs, will end up in \code{V1} and \code{V2} columns.}

\item{upper}{When \code{FALSE}(Default), duplicated combinations would be removed.}

\item{diag}{Whether to include diagonal (V1==V2) in output. Default uses \code{FALSE}.}

\item{sort}{Whether to sort rows by counts. Default uses \code{TRUE}.}
}
\value{
A data.table with 3 columns (named as "item1","item2" and "n"), containing combinations
 in "item1" and "item2", and counts in "n".
}
\description{
Count the number of times each pair
of items appear together within a group.
For example, this could count the number of times two words appear within documents.
This function has referred to \code{pairwise_count} in \strong{widyr} package,
but with very different defaults on several parameters.
}
\examples{

dat <- data.table(group = rep(1:5, each = 2),
              letter = c("a", "b",
                         "a", "c",
                         "a", "c",
                         "b", "e",
                         "b", "f"))
pairwise_count_dt(dat,group,letter)
pairwise_count_dt(dat,group,letter,sort = FALSE)
pairwise_count_dt(dat,group,letter,upper = TRUE)
pairwise_count_dt(dat,group,letter,diag = TRUE)
pairwise_count_dt(dat,group,letter,diag = TRUE,upper = TRUE)

# The column name could be specified using character.
pairwise_count_dt(dat,"group","letter")
}
\seealso{
\code{\link[widyr]{pairwise_count}}
}
