% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-profiles-openmx.R
\name{estimate_profiles_openmx}
\alias{estimate_profiles_openmx}
\title{Estimate latent profiles using OpenMx}
\usage{
estimate_profiles_openmx(df, n_profiles, model_numbers, select_vars, ...)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{n_profiles}{Numeric vector. The number of profiles (or mixture
components) to be estimated. Each number in the vector corresponds to an
analysis with that many mixture components.}

\item{model_numbers}{Numeric vector. Numbers of the models to be estimated.
See \code{\link{estimate_profiles}} for a description of the models available
in tidyLPA.}

\item{select_vars}{Character. Optional vector of variable names in \code{df},
to be used for model estimation. Defaults to \code{NULL}, which means all
variables in \code{df} are used.}

\item{...}{Parameters passed to and from functions.}
}
\value{
An object of class 'tidyLPA' and 'list'
}
\description{
Estimates latent profiles using the R-package `OpenMx`.
Note that this requires installing `OpenMx` and running `library(OpenMx)`.
}
\author{
Caspar J. van Lissa
}
