% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reads_track.R
\name{reads_track}
\alias{reads_track}
\title{Output reads across pipeline}
\usage{
reads_track(l, sample_pattern = "^[A-Za-z0-9]*")
}
\arguments{
\item{l}{List of elements to retrieved reads from.}

\item{sample_pattern}{Pattern used to extract sample names from FASTQ files.}
}
\value{
Dataframe with tracked reads through the pipeline. The first column
is named 'sample' and the following
}
\description{
It generates a dataframe with tracked reads per samples per locus.
through the pipeline, from dataframes or FASTQ files.
}
\details{
'l' is a named list. It can be either a dataframe with two
mandatory fields ('sample' and 'reads'),
or a character vector with 2 elements: 1, the path to a directory containing
FASTQ files; and
,2, a pattern matching desired FASTQ files. By, default, sample names
matching
'sample_pattern'  '^[A-Za-z0-9]*' are extracted from FASTQ files.
'left_join()' is used
iteratively from the first to the last element in 'l', so the elements in 'l'
need to be nested from element 1 to the last.
}
\examples{
# from folder with FASTQ files
path2truncated <-
   system.file("extdata", "truncated",
             package = "tidyGenR")
l <- list(
      truncated = c(path2truncated, "F_filt.fastq.gz"))
reads_track(l)
}
