% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfrmt_sigdig.R
\name{tfrmt_sigdig}
\alias{tfrmt_sigdig}
\title{Create tfrmt object from significant digits spec}
\usage{
tfrmt_sigdig(
  sigdig_df,
  group = vars(),
  label = quo(),
  param_defaults = param_set(),
  missing = NULL,
  tfrmt_obj = NULL,
  ...
)
}
\arguments{
\item{sigdig_df}{data frame containing significant digits formatting spec.
Has 1 record per group/label value, and columns for relevant group and/or
label variables, as well as a numeric column \code{sigdig} containing the
significant digits rounding to be applied in addition to the default. If
unique group/label values are represented in multiple rows, this will
result in only one of the \code{sigdig} values being carried through in
implementation.}

\item{group}{what are the grouping vars of the input dataset}

\item{label}{what is the label column of the input dataset}

\item{param_defaults}{Option to override or add to default parameters.}

\item{missing}{missing option to be included in all \code{frmt}s}

\item{tfrmt_obj}{an optional tfrmt object to layer}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{tfrmt} object with a \code{body_plan} constructed based on the
significant digits data spec and param-level significant digits defaults.
}
\description{
This function creates a tfrmt based on significant digits specifications for
group/label values. The input data spec provided to \code{sigdig_df} will contain
group/label value specifications. \code{tfrmt_sigdig} assumes that these columns
are group columns unless otherwise specified. The user may optionally choose
to pass the names of the group and/or label columns as arguments to the
function.
}
\details{
\subsection{Formats covered}{

Currently covers specifications for \code{frmt} and
\code{frmt_combine}. \code{frmt_when} not supported and must be supplied in additional
\code{tfrmt} that is layered on.
}

\subsection{Group/label variables}{

If the group/label variables are not provided to the arguments, the body_plan
will be constructed from the input data with the following behaviour:
\itemize{
\item If no group or label are supplied, it will be assumed that all columns in the input
data are group columns.
\item If a label variable is provided, but nothing is
specified for group, any leftover columns (i.e. not matching \code{sigdig} or the
supplied label variable name) in the input data will be assumed to be group
columns.
\item If any group variable is provided, any leftover columns (i.e. not
matching \code{sigdig} or the supplied group/label variable) will be disregarded.
}
}
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{sig_input <- tibble::tribble(
  ~group1,   ~group2, ~sigdig,
  "CHEMISTRY",   ".default", 3,
  "CHEMISTRY",   "ALBUMIN",  1,
  "CHEMISTRY",   "CALCIUM",   1,
  ".default",    ".default",  2
)

# Subset data for the example
data <- dplyr::filter(data_labs, group2 == "BASOPHILS", col1 \%in\% c("Placebo", "Xanomeline Low Dose"))
tfrmt_sigdig(sigdig_df = sig_input,
             group = vars(group1, group2),
             label = rowlbl,
             param_defaults = param_set("[\{n\}]" = NA)) |>
  tfrmt(column = vars(col1, col2),
        param = param,
        value = value,
        sorting_cols = vars(ord1, ord2, ord3),
        col_plan = col_plan(-starts_with("ord"))) |>
  print_to_gt(.data = data)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/master/images/example_sigdig.png" alt="Table of Hematology, which are rounded for visits baseline to week 26" style="width:100\%;">
}}
}

