% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_biomarkers_subgroups.R
\name{h_biomarkers_subgroups}
\alias{h_biomarkers_subgroups}
\alias{h_tab_one_biomarker}
\alias{h_tab_rsp_one_biomarker}
\alias{h_tab_surv_one_biomarker}
\title{Helper functions for tabulation of a single biomarker result}
\usage{
h_tab_one_biomarker(
  df,
  afuns,
  colvars,
  na_str = default_na_str(),
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

h_tab_rsp_one_biomarker(
  df,
  vars,
  na_str = default_na_str(),
  .indent_mods = 0L,
  ...
)

h_tab_surv_one_biomarker(
  df,
  vars,
  time_unit,
  na_str = default_na_str(),
  .indent_mods = 0L,
  ...
)
}
\arguments{
\item{df}{(\code{data.frame})\cr results for a single biomarker. For \code{h_tab_rsp_one_biomarker()}, the results returned by
\code{\link[=extract_rsp_biomarkers]{extract_rsp_biomarkers()}}. For \code{h_tab_surv_one_biomarker()}, the results returned by
\code{\link[=extract_survival_biomarkers]{extract_survival_biomarkers()}}.}

\item{afuns}{(named \code{list} of \code{function})\cr analysis functions.}

\item{colvars}{(named \code{list})\cr named list with elements \code{vars} (variables to tabulate) and \code{labels} (their labels).}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{time_unit}{(\code{string})\cr label with unit of median survival time. Default \code{NULL} skips displaying unit.}
}
\value{
An \code{rtables} table object with statistics in columns.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\section{Functions}{
\itemize{
\item \code{h_tab_one_biomarker()}: Helper function to calculate statistics in columns for one biomarker.

\item \code{h_tab_rsp_one_biomarker()}: Helper function that prepares a single response sub-table given the results for a
single biomarker.

\item \code{h_tab_surv_one_biomarker()}: Helper function that prepares a single survival sub-table given the results for a
single biomarker.

}}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  mutate(rsp = AVALC == "CR")
formatters::var_labels(adrs_f) <- c(adrs_labels, "Response")

# For a single population, separately estimate the effects of two biomarkers.
df <- h_logistic_mult_cont_df(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX"
  ),
  data = adrs_f
)

# Starting from above `df`, zoom in on one biomarker and add required columns.
df1 <- df[1, ]
df1$subgroup <- "All patients"
df1$row_type <- "content"
df1$var <- "ALL"
df1$var_label <- "All patients"

h_tab_rsp_one_biomarker(
  df1,
  vars = c("n_tot", "n_rsp", "prop", "or", "ci", "pval")
)

adtte <- tern_ex_adtte

# Save variable labels before data processing steps.
adtte_labels <- formatters::var_labels(adtte, fill = FALSE)

adtte_f <- adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  mutate(
    AVALU = as.character(AVALU),
    is_event = CNSR == 0
  )
labels <- c("AVALU" = adtte_labels[["AVALU"]], "is_event" = "Event Flag")
formatters::var_labels(adtte_f)[names(labels)] <- labels

# For a single population, separately estimate the effects of two biomarkers.
df <- h_coxreg_mult_cont_df(
  variables = list(
    tte = "AVAL",
    is_event = "is_event",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX",
    strata = c("STRATA1", "STRATA2")
  ),
  data = adtte_f
)

# Starting from above `df`, zoom in on one biomarker and add required columns.
df1 <- df[1, ]
df1$subgroup <- "All patients"
df1$row_type <- "content"
df1$var <- "ALL"
df1$var_label <- "All patients"
h_tab_surv_one_biomarker(
  df1,
  vars = c("n_tot", "n_tot_events", "median", "hr", "ci", "pval"),
  time_unit = "days"
)

}
