% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionalInput.R
\name{optionalSliderInputValMinMax}
\alias{optionalSliderInputValMinMax}
\title{Optional Slider Input with minimal and maximal values}
\usage{
optionalSliderInputValMinMax(
  inputId,
  label,
  value_min_max,
  label_help = NULL,
  ...
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value_min_max}{(\code{numeric(1)} or \code{numeric(3)})\cr
If of length 1 then the value gets set to that number and the \code{sliderInput} will be hidden.
Otherwise, if it is of length three the three elements will map to \code{value}, \code{min} and \code{max} of
the \code{\link[=optionalSliderInput]{optionalSliderInput()}} function.}

\item{label_help}{(\code{shiny.tag}) optional\cr
object of class \code{shiny.tag}, e.g. an object returned by \code{\link[shiny:helpText]{shiny::helpText()}}}

\item{...}{optional arguments to \code{sliderInput}}
}
\value{
(\code{shiny.tag}) HTML tag with range \code{sliderInput} widget.
}
\description{
The \code{\link[=optionalSliderInput]{optionalSliderInput()}} function needs three arguments to determine
whether to hide the \code{sliderInput} widget or not. For \code{teal} modules we specify an
optional slider input with one argument here called \code{value_min_max}.
}
\details{
For \code{teal} modules we parameterize an \code{optionalSliderInput} with one argument
\code{value_min_max}
}
\examples{

ui <- bslib::page_fluid(
  shinyjs::useShinyjs(),
  optionalSliderInputValMinMax("a1", "b1", 1), # Hidden
  optionalSliderInputValMinMax("a2", "b2", c(3, 1, 5)) # Shown
)
if (interactive()) {
  shiny::shinyApp(ui, function(input, output) {})
}
}
