% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toHTML.R
\name{toHTML.default}
\alias{toHTML.default}
\alias{teal_card-preview}
\title{Convert report objects to HTML}
\usage{
\method{toHTML}{default}(x, ...)
}
\arguments{
\item{x}{The object to convert to HTML. Supported types include:
\itemize{
\item \code{teal_card}: A list-like structure containing report elements
\item \code{teal_report}: A report object containing a \code{teal_card}
\item \code{ReportCard}: Deprecated R6 class for report cards
\item \code{code_chunk}: Code blocks created with \code{\link[=code_chunk]{code_chunk()}}
\item \code{chunk_output}: Output from evaluated code chunks
\item Plot objects: \code{ggplot}, \code{recordedplot}, \code{trellis}, \code{grob}
\item Table objects: \code{data.frame}, \code{rtables}, \code{TableTree}, \code{ElementaryTable},
\code{listing_df}, \code{gtsummary}, \code{flextable}, \code{datatables}
\item Text: \code{character} strings (rendered as markdown)
\item Other objects: Conditions, model summaries, etc.
}}

\item{...}{Additional arguments passed to methods.}
}
\value{
An HTML representation of the input object. The exact return type depends on the
input class:
\itemize{
\item For \code{teal_card}: A \code{bslib::card()} containing all elements
\item For \code{code_chunk}: A \code{bslib::accordion()} with the code
\item For plots: A \code{shiny::tags$img()} tag
\item For text: HTML markup from markdown conversion
\item For tables: HTML table elements
}

All returns are wrapped with \code{htmltools::browsable()} to enable viewer display.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{toHTML} S3 generic method converts various report objects into HTML representations.
This is the primary method for rendering report content for display in web browsers,
IDE Viewer, or for inclusion in Shiny applications.
}
\details{
\subsection{Relationship with \code{teal_card}}{

The \code{teal_card} class is a central component in the \code{teal.reporter} ecosystem. It is an S3 list
where each element represents a piece of report content (text, plots, tables, code chunks, etc.).
The \code{toHTML} method for \code{teal_card} objects:
\enumerate{
\item Iterates through each element in the \code{teal_card} list
\item Calls \code{toHTML()} recursively on each element based on its class
\item Wraps all converted elements in a \code{\link[bslib:card]{bslib::card()}} container
}

This hierarchical conversion allows complex report structures to be rendered as styled HTML
with proper formatting for each content type.
}

\subsection{Content Type Conversions}{

\strong{Text and Markdown:} Character strings are converted to HTML using \code{CommonMark} markdown syntax.
Supports headers, lists, code blocks, emphasis, and other markdown features.

\strong{Code Chunks:} Created with \code{\link[=code_chunk]{code_chunk()}}, these are rendered as collapsible Bootstrap
accordions with syntax highlighting. The accordion includes the programming language indicator
and an icon.

\strong{Plots:} Plot objects (\code{ggplot}, \code{recordedplot}, \code{trellis}, \code{grob}) are converted to PNG
images with base64-encoded data URIs, making them self-contained in the HTML output.

\strong{Tables:} Table objects are converted to styled HTML tables, typically via \code{flextable}
for consistent formatting.
}

\subsection{Viewer Integration}{

All HTML output is wrapped with \code{\link[htmltools:browsable]{htmltools::browsable()}}, which enables:
\itemize{
\item Automatic render in IDE Viewer when displayed interactively
\item Proper HTML dependency injection (Bootstrap CSS/JavaScript, Font Awesome icons, etc.)
\item Standalone HTML files with all required resources
}

You can override the \code{browsable} behavior with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{print(toHTML(x), browse = FALSE)  # Print markup to console instead
}\if{html}{\out{</div>}}
}
}
\examples{
# Initialize empty report
report <- teal_report()

# Add arbitrary markdown elements to the report's teal_card
teal_card(report) <- c(
  teal_card(report),
  "## Document section",
  "Lorem ipsum dolor sit amet"
)

# Use within() to execute code and add code-chunk
report <- within(report, a <- 2)

# within() automatically captures code and outputs
report <- within(report, plot(a))

html <- tools::toHTML(report)
# display HTML markup in viewer
html

# Print HTML markup to console instead of viewer
print(html, browse = FALSE)

}
\seealso{
\itemize{
\item \code{\link[=teal_report]{teal_report()}} for creating report objects
\item \code{\link[=teal_card]{teal_card()}} for creating report cards
\item \code{\link[=code_chunk]{code_chunk()}} for creating code blocks
\item \code{\link[=render]{render()}} for rendering complete reports to files
}
}
