% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_glm_counts.R
\name{tm_t_glm_counts}
\alias{tm_t_glm_counts}
\title{Teal Module: Regression Counts Summary}
\usage{
tm_t_glm_counts(
  label = "Counts Module",
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  aval_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVAL"), "AVAL", fixed = TRUE),
  arm_var,
  strata_var,
  rate_mean_method = c("emmeans", "ppmeans"),
  distribution = c("negbin", "quasipoisson", "poisson"),
  offset_var,
  cov_var,
  arm_ref_comp = NULL,
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{strata_var}{(\code{character})\cr names of the variables for stratified analysis.}

\item{rate_mean_method}{(\code{character}) method used to estimate the mean odds ratio. Either "emmeans" or "ppmeans"
(as in \code{summarize_glm_count()}).}

\item{distribution}{(\code{character}) value specifying the distribution used in the regression model
(Poisson: \code{"poisson"},  Quasi-Poisson: \code{"quasipoisson"}, negative binomial: \code{"negbin"}).}

\item{offset_var}{(\code{character}) a name of the numeric variable to be used as an offset?}

\item{cov_var}{(\code{character})\cr names of the covariates variables.}

\item{arm_ref_comp}{(\code{list}) optional,\cr if specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all available choices and
pre-selected option for confidence level, each within range of (0, 1).}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
Summarize results of a Poisson negative binomial regression that is result
of a generalized linear model of one (e.g. arm) or more covariates.
}
\details{
\itemize{
\item Teal module for \code{\link[tern:summarize_glm_count]{tern::summarize_glm_count()}} analysis, that summarizes results of a
Poisson negative binomial regression.
\item The arm and stratification variables are taken from the \code{parentname} data.
}
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{table} (\code{TableTree} - output of \code{rtables::build_table()})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_t_glm_counts(
   ..., # arguments for module
   decorators = list(
     table = teal_transform_module(...) # applied only to `table` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\section{Reporting}{



This module returns an object of class \code{teal_module}, that contains a \code{server} function.
Since the server function returns a \code{teal_report} object, this makes this module reportable, which means that
the reporting functionality will be turned on automatically by the \code{teal} framework.

For more information on reporting in \code{teal}, see the vignettes:
\itemize{
\item \code{vignette("reportable-shiny-application", package = "teal.reporter")}
\item \code{vignette("adding-support-for-reporting-to-custom-modules", package = "teal")}
}

}

\examples{
data <- within(teal_data(), {
  ADSL <- tern::tern_ex_adsl
  ADTTE <- tern::tern_ex_adtte
})

join_keys(data) <- default_cdisc_join_keys[names(data)]

arm_ref_comp <- list(
  ACTARMCD = list(
    ref = "ARM B",
    comp = c("ARM A", "ARM C")
  ),
  ARM = list(
    ref = "B: Placebo",
    comp = c("A: Drug X", "C: Combination")
  )
)

ADSL <- data[["ADSL"]]
ADTTE <- data[["ADTTE"]]
# Initialize the teal app
app <- init(
  data = data,
  modules = modules(
    tm_t_glm_counts(
      dataname = "ADTTE",
      arm_var = choices_selected(
        variable_choices(ADTTE, c("ARM", "ARMCD", "ACTARMCD")),
        "ARMCD"
      ),
      arm_ref_comp = arm_ref_comp,
      aval_var = choices_selected(
        variable_choices(ADTTE, "AVAL"),
        "AVAL"
      ),
      strata_var = choices_selected(
        variable_choices(ADSL, "SEX"),
        NULL
      ),
      offset_var = choices_selected(
        variable_choices(ADSL, "AGE"),
        NULL
      ),
      cov_var = choices_selected(
        variable_choices(ADTTE, "SITEID"),
        NULL
      )
    )
  )
)

if (interactive()) {
  shinyApp(app$ui, app$server)
}
}
\seealso{
\code{summarize_glm_count()}
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpfyiko+owHdapAAtaCE44bgB9d09rXB0QJR0dAEEAEQBlABlvHXJGCEREXIhwuAAPcKh+UWoE5JTbWydsooKikvLK0nIlAF9FCCUAKyJg8IBrOFZRdiioG0MdfjhjKGFScIJ+WlECcOHRiangaHhp2bkAXVdoRhhwxmWNohhUbLpRUnZapIBhWySsABZH4pHQAXh070+tUSD2M4J0CjAAMBOgAQkjcDCdMQXgiCF9kUDkpjEUTUT8kf1EnIsRBEiiEVCvvTEjo4QikWjEDoAArUKAEOD0IiY7G414QglIpI8lKMQQAcx0AA1SUifjyfs96MEPJYBmBqTp+v0lKlMtlZsBgDL0hkkRcrhBUg0mgtrbbkfVGo7nQBiHQASWkGm4tAAXrpAtGwtQdGhUEpE9lgv4WYlZgjZnTEnwhCJRAj88IxBm2aQ7utFdQ7sQzKRptjMx4oCddBC7W6xay2QnbuFNCx8QERkLROFRHAROo4Pxy33EkPGLQoPQRBtRzIy67GrFpeT1eSQUffv8gSejbTm2yZReUkib9fe2yWHc4U88RC3-dHhLc4uUBDtQg7DlKW7jpO05wLO843kuLCruucCbmOO4+k4sQygAakkDpGgBi5kkkuH4U+hFsh8zCeKBjAjmhE5TjO5BwS+fbLkhG4EBB6GZFhYBpE4aoEfBOgAHIOBkDpsSaFGJEQxjGFO6zLvR26MdBsELouHFrlxPHTBaGT8UkADiLgiTJiQSVJ5E3sQmi0WpkFMTBLHaexiF6Sh3EMewu6YWSaRBo0QYPpZRHWZJ0lEcaNK1Ka1y0PC7DBLkgoaNo1g2PErKiEEECsEk6DsImAAkgi0LE5VTow2iMP0PRgD0FxAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpfyiko+owHdapAAtaCE44bgB9d09rXB0QJR0dAEEAEQBlABlvHXJGCEREXIhwuAAPcKh+UWoE5JTbWydsooKikvLK0nIlAF9FCCUAKyJg8IBrOFZRdiioG0MdfjhjKGFScIJ+WlECcOHRiangaHhp2bkAXVdoRhhwxmWNohhUbLpRUnZapIBhWySsABZH4pHQAXh070+tUSD2M4J0CjAAMBOgAQkjcDCdMQXgiCF9kUDkpjEUTUT8kf1EnIsRBEiiEVCvvTEjo4QikWjEDoAArUKAEOD0IiY7G414QglIpI8lKMQQAcx0AA1SUifjyfs96MEPJYBmBqTp+v0lKlMtlZsBgDL0hkkRcrhBUg0mgtrbbkfVGo7nQBiHQASWkGm4tAAXrpAtGwtQdGhUEpE9lgv4WYlZgjZnTEnwhCJRAj88IxBm2aQ7utFdQ7sQzKRptjMx4oCddBC7W6xay2QnbuFNCx8QERkLROFRHAROo4Pxy33EkPGLQoPQRBtRzIy67GrFpeT1eSQUffv8gSejbTm2yZReUkib9fe2yWHc4U88RC3-dHhLc4uUBDtQg7DlKW7jpO05wLO843kuLCruucCbmOO4+k4sQygAakkDpGgBi5kkkuH4U+hFsh8zCeKBjAjmhE5TjO5BwS+fbLkhG4EBB6GZFhYBpE4aoEfBOgAHIOBkDpsSaFGJEQxjGFO6zLvR26MdBsELouHFrlxPHTBaGT8UkADiLgiTJiQSVJ5E3sQmi0WpkFMTBLHaexiF6Sh3EMewu6YWSaRBo0QYPpZRHWZJ0lEcaNK1Ka1y0PC7DBLkgoaNo1g2PErKiEEECsEk6DsImAAkgi0LE5VTow2iMP0PRgD0FxAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

