% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db_disconnect}
\alias{db_disconnect}
\title{Disconnect from PostgreSQL Database}
\usage{
db_disconnect(con)
}
\arguments{
\item{con}{A connection object as produced by \code{\link{db_connect}} or
\code{DBI::dbConnect}.}
}
\value{
Invisibly returns NULL. Called for side effects.
}
\description{
Safely closes a database connection. Checks if the connection is valid
before attempting to disconnect.
}
\details{
This function wraps \code{RPostgres::dbDisconnect()} with a validity check
to avoid errors when disconnecting an already-closed connection.
}
\examples{
\dontrun{
# Not run:
# Connect and disconnect
con <- db_connect()
# ... perform database operations ...
db_disconnect(con)

# Safe to call on.exit to ensure cleanup
con <- db_connect()
on.exit(db_disconnect(con), add = TRUE)
}
}
\seealso{
\code{\link{db_connect}}
}
