% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_config_get.R
\name{tar_config_get}
\alias{tar_config_get}
\title{Get configuration settings.}
\usage{
tar_config_get(
  name,
  config = Sys.getenv("TAR_CONFIG", "_targets.yaml"),
  project = Sys.getenv("TAR_PROJECT", "main")
)
}
\arguments{
\item{name}{Character of length 1, name of the specific
configuration setting to retrieve.}

\item{config}{Character of length 1, file path of the YAML
configuration file with \code{targets} project settings.
The \code{config} argument specifies which YAML configuration
file that \code{tar_config_get()} reads from or \code{tar_config_set()}
writes to in a single function call.
It does not globally change which configuration file is used
in subsequent function calls. The default file path of the YAML
file is always \verb{_targets.yaml} unless you set another
default path using the \code{TAR_CONFIG} environment variable,
e.g. \code{Sys.setenv(TAR_CONFIG = "custom.yaml")}. This also has the
effect of temporarily modifying the default arguments to other functions
such as \code{\link[=tar_make]{tar_make()}} because the default arguments
to those functions are controlled by \code{tar_config_get()}.}

\item{project}{Character of length 1, name of the current
\code{targets} project. Thanks to the \code{config} R package,
\code{targets} YAML configuration files can store multiple
sets of configuration settings, with each set corresponding
to its own project. The \code{project} argument allows you to
set or get a configuration setting for a specific project
for a given call to \code{tar_config_set()} or \code{tar_config_get()}.
The default project is always called \code{"main"}
unless you set another
default project using the \code{TAR_PROJECT} environment variable,
e.g. \code{Sys.setenv(tar_project = "custom")}. This also has the
effect of temporarily modifying the default arguments to other functions
such as \code{\link[=tar_make]{tar_make()}} because the default arguments
to those functions are controlled by \code{tar_config_get()}.}
}
\value{
The value of the configuration setting from
the YAML configuration file (default: \verb{_targets.yaml})
or the default value if the setting is not available.
The data type of the return value depends on your choice
of \code{name}.
}
\description{
Read the custom settings for the current project
in the optional YAML configuration file.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\section{Configuration}{

For several key functions like \code{\link[=tar_make]{tar_make()}}, the
default values of arguments are controlled though
\code{tar_config_get()}. \code{tar_config_get()} retrieves data
from an optional YAML configuration file.
You can control the settings in the YAML
file programmatically with \code{tar_config_set()}.
The default file path of this YAML file is \verb{_targets.yaml}, and you can
set another path globally using the \code{TAR_CONFIG}
environment variable. The YAML file can store configuration
settings for multiple projects, and you can globally
set the default project with the \code{TAR_PROJECT} environment
variable.
The structure of the YAML file
follows rules similar to the \code{config} R package, e.g.
projects can inherit settings from one another using the \code{inherits} field.
Exceptions include:
\enumerate{
\item There is no requirement to have a configuration named \code{"default"}.
\item Other projects do not inherit from the default project` automatically.
\item Not all fields need values because \code{targets} already has defaults.
}

\code{targets} does not actually invoke
the \code{config} package. The implementation in \code{targets}
was written from scratch without viewing or copying any
part of the source code of \code{config}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(list(tar_target(x, 1 + 1)))
tar_config_get("store") # "_targets"
store_path <- tempfile()
tar_config_set(store = store_path)
tar_config_get("store") # Shows a temp file.
tar_make() # Writes to the custom data store identified in _targets.yaml.
tar_read(x) # tar_read() knows about _targets.yaml too.
file.exists("_targets") # FALSE
file.exists(store_path) # TRUE
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_projects}()},
\code{\link{tar_config_set}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_config_yaml}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()},
\code{\link{tar_option_unset}()},
\code{\link{tar_option_with}()}
}
\concept{configuration}
