% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_glmnet.R
\name{learner_glmnet_cv}
\alias{learner_glmnet_cv}
\title{Construct a learner}
\usage{
learner_glmnet_cv(
  formula,
  info = "glmnet::cv.glmnet",
  family = gaussian(),
  lambda = NULL,
  alpha = 1,
  nfolds = 10,
  learner.args = NULL,
  ...
)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{family}{Either a character string representing
one of the built-in families, or else a \code{glm()} family object. For more
information, see Details section below or the documentation for response
type (above).}

\item{lambda}{Optional user-supplied lambda sequence; default is
\code{NULL}, and \code{glmnet} chooses its own sequence. Note that this is done
for the full model (master sequence), and separately for each fold.
The fits are then alligned using the master sequence (see the \code{allignment}
argument for additional details). Adapting \code{lambda} for each fold
leads to better convergence. When \code{lambda} is supplied, the same sequence
is used everywhere, but in some GLMs can lead to convergence issues.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0\le\alpha\le 1}.
The penalty is defined as
\deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.} \code{alpha=1} is the
lasso penalty, and \code{alpha=0} the ridge penalty.}

\item{nfolds}{number of folds - default is 10. Although \code{nfolds} can be
as large as the sample size (leave-one-out CV), it is not recommended for
large datasets. Smallest value allowable is \code{nfolds=3}}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Other arguments that can be passed to glmnet, for example \code{alpha}, \code{nlambda}, etc. See \code{glmnet} for details.}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for fitting entire lasso or
elastic-net regularization paths for various linear and non-linear regression
models with \link[glmnet:cv.glmnet]{glmnet::cv.glmnet}. Predictions are returned for the value of
\code{lambda} that gives minimum \code{cvm}. That is, \link[glmnet:predict.cv.glmnet]{glmnet::predict.cv.glmnet} is
called with \code{s = "lambda.min"}.
}
\examples{
# continuous outcome
n <- 5e2
x1 <- rnorm(n, sd = 2)
x2 <- rnorm(n)
lp <- x1 + x2*x1 + cos(x1)
y <- rnorm(n, lp, sd = 2)
d0 <- data.frame(y, x1, x2)

lr <- learner_glmnet_cv(y ~ x1 + x2)
lr$estimate(d0, nfolds = 3)
lr$predict(data.frame(x1 = c(0, 1), x2 = 1))

# count outcome with different exposure time
w <- 50 + rexp(n, rate = 1 / 5)
y <- rpois(n, exp(0.5 * x1 - 1 * x2 + log(w)) * rgamma(n, 1 / 2, 1 / 2))
d0 <- data.frame(y, x1, x2, w)

lr <- learner_glmnet_cv(y ~ x1 + x2 + offset(log(w)), family = "poisson")
lr$estimate(d0, nfolds = 3)
lr$predict(data.frame(x1 = 1, x2 = 1, w = c(1, 5)))
}
