% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvevents.R
\name{ggsurvevents}
\alias{ggsurvevents}
\title{Distribution of Events' Times}
\usage{
ggsurvevents(
  surv = NULL,
  fit = NULL,
  data = NULL,
  type = "fraction",
  normalized = TRUE,
  censored.on.top = TRUE,
  ggtheme = theme_survminer(),
  palette = c("grey75", "grey25"),
  ...
)
}
\arguments{
\item{surv}{an object of \link[survival]{Surv}. If not suplied, the censoring variable is extracted from the model.}

\item{fit}{an object of class \link[survival]{survfit}.}

\item{data}{a dataset for predictions. If not supplied then data will be extracted from `fit` object.}

\item{type}{one of \code{c("cumulative", "radius", "fraction")}. \code{"cumulative"} stands for cumulative number of events, \code{"radius"} stands for number of events within a given radius,}

\item{normalized}{if \code{TRUE} relative number of events is presented,}

\item{censored.on.top}{is TRUE then censored events are on the top}

\item{ggtheme}{function, ggplot2 theme name.  Allowed values include ggplot2 official themes: see theme.}

\item{palette}{the color palette to be used for coloring of significant variables.}

\item{...}{other graphical parameters to be passed to the function \link[ggpubr]{ggpar}.}
}
\value{
return an object of class ggplot
}
\description{
Distribution of Events' Times
}
\examples{
require("survival")
# from Surv
surv <- Surv(lung$time, lung$status)
ggsurvevents(surv)

surv2 <- Surv(colon$time, colon$status)
ggsurvevents(surv2)
ggsurvevents(surv2, normalized = TRUE)

# from survfit
fit <- survfit(Surv(time, status) ~ sex, data = lung)
ggsurvevents(fit = fit, data = lung)

# from coxph
model <- coxph( Surv(time, status) ~ sex + rx + adhere, data = colon )
ggsurvevents(fit = model, data = colon)
ggsurvevents(surv2, normalized = TRUE, type = "radius")
ggsurvevents(surv2, normalized = TRUE, type = "fraction")

}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
