% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustments.R
\name{get_stats19_adjustments}
\alias{get_stats19_adjustments}
\title{Download and read-in severity adjustment factors}
\usage{
get_stats19_adjustments(
  data_dir = get_data_directory(),
  u = paste0("https://data.dft.gov.uk/road-accidents-safety-data/",
    "dft-road-casualty-statistics-casualty-adjustment-lookup_",
    "2004-latest-published-year.csv")
)
}
\arguments{
\item{data_dir}{Where sets of downloaded data would be found.}

\item{u}{The URL of the zip file with adjustments to download}
}
\description{
See the DfT's documentation on adjustment factors
\href{https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/833813/annex-update-severity-adjustments-methodology.pdf}{Annex: Update to severity adjustments methodology}.
}
\details{
See \href{https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/820588/severity-reporting-methodology-final-report.odt}{Estimating and adjusting for changes in the method of severity reporting for road accidents and casualty data: final report}
for details.
}
\examples{
\dontrun{
if(curl::has_internet()) {
adjustment = get_stats19_adjustments()
}
}
}
