% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impacts.R
\name{impacts.stsls_sphet}
\alias{impacts.stsls_sphet}
\title{Generate impacts for objects of class lag_gmm created in sphet}
\usage{
\method{impacts}{stsls_sphet}(
  obj,
  ...,
  tr = NULL,
  R = NULL,
  listw = NULL,
  evalues = NULL,
  tol = 1e-06,
  empirical = FALSE,
  Q = NULL,
  KPformula = FALSE,
  prt = TRUE
)
}
\arguments{
\item{obj}{A spreg spatial regression object created by \code{spreg} with model ="lag"}

\item{...}{Arguments passed through to methods in the \pkg{coda} package}

\item{tr}{A vector of traces of powers of the spatial weights matrix created using \code{trW}, for approximate impact measures; if not given, \code{listw} must be given for exact measures (for small to moderate spatial weights matrices); the traces must be for the same spatial weights as were used in fitting the spatial regression}

\item{R}{If given, simulations are used to compute distributions for the impact measures, returned as \code{mcmc} objects}

\item{listw}{a listw object}

\item{evalues}{vector of eigenvalues of spatial weights matrix for impacts calculations}

\item{tol}{Argument passed to \code{mvrnorm}: tolerance (relative to largest variance) for numerical lack of positive-definiteness in the coefficient covariance matrix}

\item{empirical}{Argument passed to \code{mvrnorm} (default FALSE): if true, the coefficients and their covariance matrix specify the empirical not population mean and covariance matrix}

\item{Q}{default NULL, else an integer number of cumulative power series impacts to calculate if \code{tr} is given}

\item{KPformula}{default FALSE, else inference of the impacts based on Kelejian and Piras (2020)}

\item{prt}{prints the KP summary of the VC matrix}
}
\value{
Estimate of the Average Total, Average Direct, and Average Indirect Effects
}
\description{
Generate impacts for objects of class lag_gmm created in sphet
}
\examples{
require("sf", quietly=TRUE)
library(coda)
columbus <- st_read(system.file("shapes/columbus.gpkg", package="spData")[1], quiet=TRUE)
col.gal.nb <- spdep::read.gal(system.file("weights/columbus.gal", package="spData")[1])
listw <- spdep::nb2listw(col.gal.nb)
ev <- spatialreg::eigenw(listw)
W <- as(listw, "CsparseMatrix")
trMatc <- spatialreg::trW(W, type="mult")
trMC <- spatialreg::trW(W, type="MC")
#LAG
lobj_gm <- spreg(CRIME ~ INC + HOVAL, columbus, listw,
                model = "lag")
summary(lobj_gm)
lobj_gmh <- spreg(CRIME ~ INC + HOVAL, columbus, listw,
                 model = "lag", het = TRUE)
summary(lobj_gmh)
set.seed(1)
impacts(lobj_gm, listw=listw)
impacts(lobj_gm, tr=trMatc)
impacts(lobj_gm, tr=trMC)
impacts(lobj_gm, evalues=ev)
impacts(lobj_gmh, listw=listw)
impacts(lobj_gmh, tr=trMatc)
impacts(lobj_gmh, tr=trMC)
impacts(lobj_gmh, evalues=ev)
#same impacts but different SD
summary(impacts(lobj_gm, evalues = ev, R = 1000))
summary(impacts(lobj_gmh, evalues = ev, R = 1000))
lobjIQ5_gm <- impacts(lobj_gm, tr=trMatc, R=1000, Q=5)
summary(lobjIQ5_gm, zstats=TRUE, short=TRUE)
summary(lobjIQ5_gm, zstats=TRUE, short=TRUE, reportQ=TRUE)
# LAG durbin TRUE
mobj_gm <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin=TRUE,
                model = "lag")
summary(mobj_gm)
mobj_gmh <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin=TRUE,
                 model = "lag", het = TRUE)
mobj_gm2 <- spreg(CRIME ~ INC, columbus, listw, Durbin=TRUE,
                model = "lag")
summary(mobj_gmh)
impacts(mobj_gm, KPformula = TRUE)
impacts(mobj_gm2, KPformula = TRUE)
summary(impacts(mobj_gm2, evalues=ev, R=1000), short=TRUE, zstats=TRUE)
impacts(mobj_gm, listw=listw)
impacts(mobj_gm, tr=trMatc)
impacts(mobj_gm, tr=trMC)
impacts(mobj_gm, evalues=ev)
summary(impacts(mobj_gm, evalues=ev, R=1000), short=TRUE, zstats=TRUE)
impacts(mobj_gmh, listw=listw)
impacts(mobj_gmh, tr=trMatc)
impacts(mobj_gmh, tr=trMC)
impacts(mobj_gmh, evalues=ev)
summary(impacts(mobj_gmh, tr=trMatc, R=1000), short=TRUE, zstats=TRUE)
#lag durbin = ~formula
mobj1_gm <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin= ~ INC,
                 model = "lag")
mobj1_gmh <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin= ~ INC,
                  model = "lag", het = TRUE)
impacts(mobj1_gm, tr=trMatc)
impacts(mobj1_gm, listw=listw)
impacts(mobj1_gm, KPformula = TRUE)
summary(impacts(mobj_gm, evalues=ev, R=200), short=TRUE, zstats=TRUE)
summary(impacts(mobj1_gm, tr=trMatc, R=200), short=TRUE, zstats=TRUE)
mobj1_gm <- spreg(CRIME ~ HOVAL, columbus, listw, Durbin= ~ INC,
                 model = "lag")
summary(impacts(mobj1_gm, evalues=ev, R=200), short=TRUE, zstats=TRUE)
}
\references{
Roger Bivand, Gianfranco Piras (2015). Comparing Implementations of Estimation Methods for Spatial Econometrics. \emph{Journal of Statistical Software}, 63(18), 1-36. \url{https://www.jstatsoft.org/v63/i18/}.
Harry Kelejian, Gianfranco Piras (2020). Spillover effects in spatial models: Generalization and extensions. \emph{Journal of Regional Science}, 60(3), 425-442. 
Gianfranco Piras, Paolo Postiglione (2022).  A deeper look at impacts in spatial Durbin model with sphet. \emph{Geographical Analysis}, 54(3), 664-684.
}
