% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trophic.R
\name{add_link}
\alias{add_link}
\title{Add links to a trophic table}
\usage{
add_link(tbl, from, to, weight = 1)
}
\arguments{
\item{tbl}{A \code{trophic_tbl} object.}

\item{from}{A single character string indicating the source node.}

\item{to}{A character vector indicating target nodes.}

\item{weight}{A numeric vector of weights associated with each link.
If a single value is provided, it is recycled to match the length of \code{to}.}
}
\value{
A validated \code{trophic_tbl} object with the new links added.
}
\description{
Adds one or several directed links to a trophic_tbl object.
}
\details{
The function performs several checks:
\itemize{
  \item \code{from} must be a scalar character string
  \item \code{to} must be a character vector
  \item Links must be unique
  \item Self-loops (from == to) are forbidden
  \item The resulting graph must remain acyclic
}
}
\examples{
net <- trophic() |>
  add_link("a", "b", weight = 1)

}
