% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{findPeaks}
\alias{findPeaks}
\title{Find peaks}
\usage{
findPeaks(x, wl = 3, thres = NULL)
}
\arguments{
\item{x}{numeric vector}

\item{wl}{rolling window over which we look for maxima: central value ±
floor(wl/2), eg ±1 if wl=3}

\item{thres}{required absolute value of each peak}
}
\value{
Returns a vector with indices of local maxima
}
\description{
A bare-bones, very fast function to find local maxima (peaks) in a numeric
vector.
}
\examples{
x = rnorm(100)
findPeaks(x, wl = 3)
findPeaks(x, wl = 3, thres = 1)
findPeaks(x, wl = 5)
idx = findPeaks(x, wl = 5, thres = 1)
plot(x, type = 'b'); abline(h = 1, lty = 3)
points(idx, x[idx], col = 'blue', pch = 8)
}
\seealso{
\code{\link{findInflections}}
}
