% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{findZeroCrossing}
\alias{findZeroCrossing}
\title{Find zero crossing}
\usage{
findZeroCrossing(ampl, location)
}
\arguments{
\item{ampl}{a vector of amplitudes oscillating around zero, such as a sound
waveform}

\item{location}{the index indicating the desired location of a zero crossing}
}
\value{
Returns the index of the last negative value before zero crossing
  closest to specified location.
}
\description{
Internal soundgen function.
}
\details{
\code{findZeroCrossing} looks for the last negative point before a zero
crossing as close as possible to the specified location. Since this is
primarily intended for joining waveforms without a click, this function only
looks at upward segments of a waveform (see example).
}
\examples{
ampl = sin(1:100/2)
plot(ampl, type = 'b')
lines(1:100, rep(0,100), lty = 2)
zc = vector()
for (i in seq_along(ampl)){
  zc[i] = soundgen:::findZeroCrossing (ampl, i)
  # find zc closest to each of 100 points
}
for (z in unique(zc)){
  points(z, ampl[z], col = 'red', pch = 17)
  # only on upward segments
}
zc # see which zc is closest to each point
}
\keyword{internal}
