% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency_scales.R
\name{HzToOther}
\alias{HzToOther}
\alias{otherToHz}
\title{Convert between Hz and other frequency scales}
\usage{
HzToOther(
  x,
  scale = c("ERB", "bark", "mel", "log", "semitones", "notes")[1],
  ...
)

otherToHz(
  x,
  scale = c("ERB", "bark", "mel", "log", "semitones", "notes")[1],
  ...
)
}
\arguments{
\item{x}{vector or matrix of frequencies}

\item{scale}{target scale: "bark" = Zwicker's critical bandwidth scale
calculated as in Wang et al. 1992 (see
https://en.wikipedia.org/wiki/Bark_scale), "mel" = O'Shaughnessy's original
formula (https://en.wikipedia.org/wiki/Mel_scale), "ERB" = Equivalent
Rectangular Bandwidth rate (see \code{\link{HzToERB}}), "log" = log2,
"semitones" = semitones relative to a reference value (see
\code{\link{HzToSemitones}}), "notes" = musical notation (see
\code{\link{HzToNotes}}), "linear" = no change}

\item{...}{other arguments passed on to the scale-specific function}
}
\description{
Converts betwen Hz and ERB, bark, mel, log, semitones relative to a reference
frequency, or musical notes. Accepts vectors and missing values.
}
\examples{
x = c(-20, 20, 100, 440, 1000, NA)
HzToOther(x, 'ERB')
HzToOther(x, 'ERB', 'quadratic')
HzToOther(x, 'bark')
HzToOther(x, 'mel')
HzToOther(x, 'log')
HzToOther(x, 'semitones', ref = 16)
HzToOther(x, 'notes', showCents = TRUE)

# ...and back to Hz
x = c(0:10, NA)

otherToHz(x, 'ERB')
otherToHz(x, 'ERB', method = 'quadratic')
otherToHz(HzToOther(c(100, 440, 2000), 'ERB'), 'ERB')

otherToHz(x, 'bark')
otherToHz(HzToOther(c(100, 440, 2000), 'bark'), 'bark')

otherToHz(x, 'mel')
otherToHz(HzToOther(c(100, 440, 2000), 'mel'), 'mel')

otherToHz(x, 'log')

otherToHz(x, 'semitones')
HzToOther(c(440, 210, 880), 'semitones', ref = 440)
otherToHz(HzToOther(c(440, 210, 880), 'semitones'), 'semitones')

otherToHz(c('A4', 'C#6', 'blabla', NA), 'notes')
}
\seealso{
\code{\link{HzToSemitones}} \code{\link{HzToNotes}}
  \code{\link{HzToERB}}
}
