% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/su.R
\name{su}
\alias{su}
\title{Summary Utility (\code{su})}
\usage{
su(
  x,
  mat.var.in.col = TRUE,
  digits = 4,
  probs = c(0.1, 0.25, 0.5, 0.75, 0.9),
  print = FALSE
)
}
\arguments{
\item{x}{a numeric vector, matrix, or data frame. For matrices, variables are assumed
to be in columns; set \code{mat.var.in.col = FALSE} to treat rows as variables.}

\item{mat.var.in.col}{logical. If \code{TRUE} (default), a matrix is interpreted as variables in columns.
If \code{FALSE}, the matrix is transposed so that rows are treated as variables.}

\item{digits}{integer. Number of digits to use when printing (only affects printed output when
\code{print = TRUE}). Default is \code{4}.}

\item{probs}{numeric vector of probabilities in \eqn{[0, 1]} for which quantiles are computed.
Default is \code{c(0.1, 0.25, 0.5, 0.75, 0.9)}.}

\item{print}{logical. If \code{TRUE}, prints the transposed summary table using the specified
number of digits. Default is \code{FALSE}.}
}
\value{
A matrix (coercible to \code{data.frame}) where each row corresponds to a variable
and columns contain the summary statistics:
\code{Obs}, \code{NAs}, \code{Mean}, \code{StDev}, \code{IQR}, \code{Min},
the requested \code{probs} quantiles (named), and \code{Max}.  
The returned object is given class \code{"snreg"} for compatibility with
package-specific print/summarization methods.
}
\description{
Computes a compact table of summary statistics for each variable in a vector,
matrix, or data frame. The following metrics are returned per variable:
number of observations (\code{Obs}), missing values (\code{NAs}), mean,
standard deviation (\code{StDev}), interquartile range (\code{IQR}),
minimum (\code{Min}), user-specified quantiles (\code{probs}), and maximum (\code{Max}).
}
\details{
Compact Summary Statistics for Vectors, Matrices, and Data Frames


Input handling:
\itemize{
  \item If \code{x} is a matrix with a single row or column, it is treated like a vector.
        Column or row names are used (if available). Otherwise, a default name is created.
  \item If \code{x} is a matrix with multiple variables, variables are taken as columns.
        Use \code{mat.var.in.col = FALSE} to transpose and treat rows as variables.
  \item If \code{x} is a vector, its deparsed symbol name is used as the variable name.
  \item If \code{x} is a data frame, each column is summarized.
}

Missing values are excluded in all summary computations.
}
\examples{
  # Vector
  set.seed(1)
  v <- rnorm(100)
  su(v, print = TRUE)

  # Matrix: variables in columns
  M <- cbind(x = rnorm(50), y = runif(50))
  su(M)

  # Matrix: variables in rows
  Mr <- rbind(x = rnorm(50), y = runif(50))
  su(Mr, mat.var.in.col = FALSE)

  # Data frame
  DF <- data.frame(a = rnorm(30), b = rexp(30), c = rbinom(30, 1, 0.3))
  out <- su(DF)
  head(out)

}
