% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeNKFunction.R
\name{makeNKFunction}
\alias{makeNKFunction}
\title{Generator for NK-landscapes}
\usage{
makeNKFunction(N, K)
}
\arguments{
\item{N}{[\code{integer(1)}]\cr
Length of the bit-string (decision space dimension).}

\item{K}{[\code{integer}]\cr
Integer vector of the number of epistatic interactions.
If a single value is passed a homogeneous NK-landscape is generated, i.e.
\eqn{k_i = k \forall i = 1, \ldots, N}.}
}
\value{
[\code{smoof_single_objective_function}]
  NK-landscape function.
}
\description{
Generate a single-objective NK-landscape. NK-landscapes are combinatorial
problems with input space \eqn{\{0,1\}^N} (in their basic definition). The
value of each bit position \eqn{i \in \{1, \ldots, N\}} depends on \eqn{K}
other bits, the so-called \emph{(epistatic) links / interactions}.
}
\examples{
# generate homogeneous NK-landscape with each K=3 epistatic links
N = 20
fn = makeNKFunction(N, 3)

# evaluate function on some random bitstrings
bitstrings = matrix(sample(c(0, 1), size = 10 * N, replace = TRUE), ncol = N)
apply(bitstrings, 1, fn)

# generate heterogeneous NK-landscape where K is sampled from {2,3,4}
# uniformly at random
fn = makeNKFunction(N, K = sample(2:4, size = N, replace = TRUE))

}
\references{
Kauffman SA, Weinberger ED. The NK model of rugged fitness landscapes and
its application to maturation of the immune response. Journal of Theoretical
Biology 1989 Nov 21;141(2):211-45. doi: 10.1016/s0022-5193(89)80019-0.
}
\seealso{
Other nk_landscapes: 
\code{\link{exportNKFunction}()},
\code{\link{makeMNKFunction}()}
}
\concept{nk_landscapes}
