% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sof.hartmann.R
\name{makeHartmannFunction}
\alias{makeHartmannFunction}
\title{Hartmann Function}
\usage{
makeHartmannFunction(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Size of corresponding parameter space.}
}
\value{
An object of class \code{SingleObjectiveFunction}, representing the Hartmann Function.

[\code{smoof_single_objective_function}]
}
\description{
Uni-modal single-objective test function with six local minima.
The implementation is based on the mathematical formulation
\deqn{f(x) = - \sum_{i=1}^4 \alpha_i \ exp \left(-\sum_{j=1}^6 A_{ij}(x_j-P_{ij})^2 \right)}, where
\deqn{\alpha = (1.0, 1.2, 3.0, 3.2)^T, \\
 A = \left( \begin{array}{rrrrrr}
  10   & 3    & 17   & 3.50 & 1.7  & 8 \\
  0.05 & 10   & 17   & 0.1  & 8    & 14 \\
  3    & 3.5  & 1.7  & 10   & 17   & 8 \\
  17   & 8    & 0.05 & 10   & 0.1  & 14
 \end{array} \right), \\
  P = 10^{-4} \cdot \left(\begin{array}{rrrrrr}
  1312 & 1696 & 5569 & 124  & 8283 & 5886 \\
  2329 & 4135 & 8307 & 3736 & 1004 & 9991 \\
  2348 & 1451 & 3522 & 2883 & 3047 & 6650 \\
  4047 & 8828 & 8732 & 5743 & 1091 & 381
 \end{array} \right)}
The function is restricted to six dimensions with \eqn{\mathbf{x}_i \in [0,1], i = 1, \ldots, 6.}
The function is not normalized in contrast to some benchmark applications in the literature.
}
\references{
Picheny, V., Wagner, T., & Ginsbourger, D. (2012). A benchmark
of kriging-based infill criteria for noisy optimization.
}
