#' @title
#' El-Attar-Vidyasagar-Dutta Function
#'
#' @description
#' This function is based on the formula
#' \deqn{f(\mathbf{x}) = (\mathbf{x}_1^2 + \mathbf{x}_2 - 10)^2 + (\mathbf{x}_1 + \mathbf{x}_2^2 - 7)^2 + (\mathbf{x}_1^2 + \mathbf{x}_2^3 - 1)^2}
#' subject to \eqn{\mathbf{x}_i \in [-500, 500], i = 1, 2}.
#' 
#' @return
#' An object of class \code{SingleObjectiveFunction}, representing the El-Attar-Vidyasagar-Dutta Function.
#'
#' @references R. A. El-Attar, M. Vidyasagar, S. R. K. Dutta, An Algorithm for
#' II-norm Minimization With Application to Nonlinear II-approximation, SIAM
#' Journal on Numerical Analysis, vol. 16, no. 1, pp. 70-86, 1979.
#'
#' @template ret_smoof_single
#' @export
makeElAttarVidyasagarDuttaFunction = function() {
  makeSingleObjectiveFunction(
    name = "El-Attar-Vidyasagar-Dutta Function",
    id = "elAttarVidyasagarDutta_2d",
    fn = function(x) {
      checkNumericInput(x, 2L)
      (x[1]^2 + x[2] - 10)^2 + (x[1] + x[2]^2 - 7)^2 + (x[1]^2 + x[2]^3 - 1)^2
    },
    par.set = ParamHelpers::makeNumericParamSet(
      len = 2L,
      id = "x",
      lower = c(-100, -100),
      upper = c(100, 100),
      vector = TRUE
    ),
    tags = attr(makeElAttarVidyasagarDuttaFunction, "tags"),
    global.opt.params = c(3.40918683, -2.17143304),
    global.opt.value = 1.712780354
  )
}

class(makeElAttarVidyasagarDuttaFunction) = c("function", "smoof_generator")
attr(makeElAttarVidyasagarDuttaFunction, "name") = c("El-Attar-Vidyasagar-Dutta")
attr(makeElAttarVidyasagarDuttaFunction, "type") = c("single-objective")
attr(makeElAttarVidyasagarDuttaFunction, "tags") = c("single-objective", "continuous", "differentiable", "non-separable", "non-scalable", "unimodal")
