% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slasso_functions.R
\name{slasso.fr_cv}
\alias{slasso.fr_cv}
\title{Cross-validation for the S-LASSO estimator}
\usage{
slasso.fr_cv(
  Y_fd,
  X_fd,
  basis_s,
  basis_t,
  K = 10,
  kss_rule_par = 0.5,
  lambda_L_vec = NULL,
  lambda_s_vec = NULL,
  lambda_t_vec = NULL,
  B0 = NULL,
  ncores = 1,
  ...
)
}
\arguments{
\item{Y_fd}{An object of class fd corresponding to the response functions.}

\item{X_fd}{An object of class fd corresponding to the covariate functions.}

\item{basis_s}{B-splines basis along the \code{s}-direction of class basisfd.}

\item{basis_t}{B-splines basis along the \code{t}-direction of class basisfd.}

\item{K}{Number of folds. Default is 10.}

\item{kss_rule_par}{Parameter of the \code{k}-standard error rule. If \code{kss_rule_par=0} the tuning parameters that minimize the estimated prediction error are chosen.  Default is 0.5.}

\item{lambda_L_vec}{Vector of regularization parameters of the functional LASSO penalty.}

\item{lambda_s_vec}{Vector of regularization parameters of the smoothness penalty along the \code{s}-direction.}

\item{lambda_t_vec}{Vector of regularization parameters of the smoothness penalty along the \code{t}-direction.}

\item{B0}{Initial estimator of the basis coefficients matrix of the coefficient function. Should have dimensions in accordance with the basis dimensions of \code{basis_s} and \code{basis_t}.}

\item{ncores}{If \code{ncores}>1, then parallel computing is used, with \code{ncores} cores. Default is 1.}

\item{...}{Other arguments to be passed to the Orthant-Wise Limited-memory Quasi-Newton optimization function. See the \code{lbfgs} help page of the package \code{lbfgs}.}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{lambda_opt_vec}: Vector of optimal tuning parameters.

\item \code{CV}:  Estimated prediction errors.

\item \code{CV_sd}:  Standard errors of the estimated prediction errors.

\item \code{per_0}: The fractions of domain where the coefficient function is zero for all the tuning parameters combinations.

\item \code{comb_list}: The combinations of \code{lambda_L},\code{lambda_s} and \code{lambda_t} explored.

\item \code{Y_fd}: The response functions.

\item \code{X_fd}: The covariate functions.
}
}
\description{
K-fold cross-validation procedure to choose the tuning parameters for the S-LASSO estimator (Centofanti et al., 2020).
}
\examples{
library(slasso)
data<-simulate_data("Scenario II",n_obs=150)
X_fd=data$X_fd
Y_fd=data$Y_fd
domain=c(0,1)
n_basis_s<-60
n_basis_t<-60
breaks_s<-seq(0,1,length.out = (n_basis_s-2))
breaks_t<-seq(0,1,length.out = (n_basis_t-2))
basis_s <- fda::create.bspline.basis(domain,breaks=breaks_s)
basis_t <- fda::create.bspline.basis(domain,breaks=breaks_t)
mod_slasso_cv<-slasso.fr_cv(Y_fd = Y_fd,X_fd=X_fd,basis_s=basis_s,basis_t=basis_t,
lambda_L_vec=seq(0,1,by=1),lambda_s_vec=c(-9),lambda_t_vec=-7,B0=NULL,
max_iterations=10,K=2,invisible=1,ncores=1)
}
\references{
Centofanti, F., Fontana, M., Lepore, A., & Vantini, S. (2022).
Smooth lasso estimator for the function-on-function linear regression model.
\emph{Computational Statistics & Data Analysis}, 176, 107556.
}
\seealso{
\code{\link{slasso.fr}}
}
