% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_csv.R
\name{sits_timeseries_to_csv}
\alias{sits_timeseries_to_csv}
\title{Export a a full sits tibble to the CSV format}
\usage{
sits_timeseries_to_csv(data, file = NULL)
}
\arguments{
\item{data}{Time series (tibble of class "sits").}

\item{file}{Full path of the exported CSV file
(valid file name with extension ".csv").}
}
\value{
Return data.frame with CSV columns (optional)
}
\description{
Converts metadata and data from a sits tibble to a CSV file.
             The CSV file will not contain the actual time
             series. Its columns will be the same as those of a
             CSV file used to retrieve data from
             ground information ("latitude", "longitude", "start_date",
             "end_date", "cube", "label"), plus the all the time series for
             each data
}
\examples{
csv_ts <- sits_timeseries_to_csv(cerrado_2classes)
csv_file <- paste0(tempdir(), "/cerrado_2classes_ts.csv")
sits_timeseries_to_csv(cerrado_2classes, file = csv_file)
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
