% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.xgb_model}
\alias{plot.xgb_model}
\title{Plot XGB model}
\usage{
\method{plot}{xgb_model}(x, ..., trees = 0L:4L, width = 1500L, height = 1900L)
}
\arguments{
\item{x}{Object of class "xgb_model".}

\item{...}{Further specifications for \link{plot}.}

\item{trees}{Vector of trees to be plotted}

\item{width}{Width of the output window}

\item{height}{Height of the output window}
}
\value{
A plot
}
\description{
Plots trees in an extreme gradient boosting model.
}
\examples{
if (sits_run_examples()) {
    # Retrieve the samples for Mato Grosso
    # train an extreme gradient boosting
    xgb_model <- sits_train(samples_modis_ndvi,
        ml_method = sits_xgboost()
    )
    plot(xgb_model)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
